/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.Replace;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.PlatformExceptionTranslator;
import org.eclipse.scout.rt.platform.extension.InjectFieldTo;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.CompositeObject;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationUtility {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationUtility.class);
    private static final ConcurrentHashMap<Class, Class[]> declaredPublicClassesCache = new ConcurrentHashMap();

    private ConfigurationUtility() {
    }

    public static <T> List<Class<? extends T>> sortFilteredClassesByOrderAnnotation(List<? extends Class> classes, Class<T> filter) {
        TreeMap<CompositeObject, Class> orderedClassesMap = new TreeMap<CompositeObject, Class>();
        int i = 0;
        for (Class clazz : classes) {
            if (!filter.isAssignableFrom(clazz)) continue;
            if (clazz.isAnnotationPresent(Order.class)) {
                Order order = clazz.getAnnotation(Order.class);
                orderedClassesMap.put(new CompositeObject(order.value(), i), clazz);
            } else {
                if (!clazz.isAnnotationPresent(Replace.class)) {
                    LOG.error("missing @Order annotation: {}", (Object)clazz.getName());
                }
                orderedClassesMap.put(new CompositeObject(Double.MAX_VALUE, i), clazz);
            }
            ++i;
        }
        return CollectionUtility.arrayList(orderedClassesMap.values());
    }

    public static <T> Class<T> filterClass(Class[] classes, Class<T> filter) {
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (filter.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers())) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static <T> Class<T> filterClassIgnoringInjectFieldAnnotation(Class[] classes, Class<T> filter) {
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (filter.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers()) && !ConfigurationUtility.isInjectFieldAnnotationPresent(c)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static <T> List<Class<T>> filterClasses(Class[] classes, Class<T> filter) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>(classes.length);
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (filter.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers())) {
                result.add(c);
            }
            ++n2;
        }
        return result;
    }

    public static <T> List<Class<T>> filterClassesIgnoringInjectFieldAnnotation(Class[] classes, Class<T> filter) {
        ArrayList<Class<T>> list = new ArrayList<Class<T>>(classes.length);
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (filter.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers()) && !ConfigurationUtility.isInjectFieldAnnotationPresent(c)) {
                list.add(c);
            }
            ++n2;
        }
        return list;
    }

    public static <T> List<Class<T>> filterClassesWithInjectFieldAnnotation(Class[] classes, Class<T> filter) {
        ArrayList<Class<T>> list = new ArrayList<Class<T>>(classes.length);
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (filter.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers()) && ConfigurationUtility.isInjectFieldAnnotationPresent(c)) {
                list.add(c);
            }
            ++n2;
        }
        return list;
    }

    public static boolean isInjectFieldAnnotationPresent(Class<?> c) {
        return c.isAnnotationPresent(InjectFieldTo.class) || c.isAnnotationPresent(Replace.class);
    }

    public static Class[] getDeclaredPublicClasses(Class c) {
        if (c.isSynthetic()) {
            return c.getClasses();
        }
        Class[] a = declaredPublicClassesCache.get(c);
        if (a != null) {
            return a;
        }
        a = c.getClasses();
        declaredPublicClassesCache.put(c, a);
        return a;
    }

    public static <T> T newInnerInstance(Object instance, Class<T> innerClass) {
        try {
            if (innerClass.getDeclaringClass() != null && (innerClass.getModifiers() & 8) == 0) {
                Constructor<T> c = innerClass.getDeclaredConstructor(innerClass.getDeclaringClass());
                return c.newInstance(instance);
            }
            return innerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw BEANS.get(PlatformExceptionTranslator.class).translate(e).withContextInfo("innerClass", innerClass, new Object[0]);
        }
    }

    public static boolean isMethodOverwrite(Class<?> declaringType, String methodName, Class[] parameterTypes, Class<?> implementationType) {
        Method declaredMethod;
        Assertions.assertNotNull(declaringType, "declaringType must not be null", new Object[0]);
        Assertions.assertNotNull(methodName, "methodName must not be null", new Object[0]);
        try {
            declaredMethod = declaringType.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.error("cannot find declared method {}.{}", new Object[]{declaringType.getName(), methodName, e});
            return false;
        }
        Class<?> c = implementationType;
        while (c != null && c != declaringType) {
            try {
                c.getDeclaredMethod(declaredMethod.getName(), declaredMethod.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                c = c.getSuperclass();
            }
        }
        return false;
    }

    public static <T> List<Class<? extends T>> removeReplacedClasses(List<? extends Class<? extends T>> classes) {
        Set<Class<T>> replacingClasses = ConfigurationUtility.getReplacingLeafClasses(classes);
        if (replacingClasses.isEmpty()) {
            return CollectionUtility.arrayList(classes);
        }
        ArrayList<Class<T>> list = new ArrayList<Class<T>>(classes.size());
        list.addAll(classes);
        for (Class<T> replacingClass : replacingClasses) {
            boolean reorder = !replacingClass.isAnnotationPresent(Order.class);
            boolean reordered = false;
            Class<T> classToBeReplaced = replacingClass.getSuperclass();
            while (classToBeReplaced.isAnnotationPresent(Replace.class)) {
                if (reorder && !reordered && classToBeReplaced.isAnnotationPresent(Order.class)) {
                    reordered = ConfigurationUtility.moveBefore(list, replacingClass, classToBeReplaced);
                }
                list.remove(classToBeReplaced);
                classToBeReplaced = classToBeReplaced.getSuperclass();
            }
            if (reorder && !reordered) {
                ConfigurationUtility.moveBefore(list, replacingClass, classToBeReplaced);
            }
            list.remove(classToBeReplaced);
        }
        return list;
    }

    public static <T> Map<Class<?>, Class<? extends T>> getReplacementMapping(List<? extends Class<? extends T>> classes) {
        Set<Class<T>> replacingClasses = ConfigurationUtility.getReplacingLeafClasses(classes);
        if (replacingClasses.isEmpty()) {
            return new HashMap(0);
        }
        HashMap mappings = new HashMap();
        Iterator<Class<T>> iterator = replacingClasses.iterator();
        while (iterator.hasNext()) {
            Class<T> c;
            Class<T> tmpClass = c = iterator.next();
            do {
                tmpClass = tmpClass.getSuperclass();
                mappings.put(tmpClass, c);
            } while (tmpClass.isAnnotationPresent(Replace.class));
        }
        return mappings;
    }

    public static <T> Set<Class<? extends T>> getReplacingLeafClasses(List<? extends Class<? extends T>> classes) {
        HashSet<Class<T>> replacingClasses = new HashSet<Class<T>>(classes.size());
        HashSet<Class<T>> replacedClasses = new HashSet<Class<T>>();
        for (Class<T> c : classes) {
            if (!c.isAnnotationPresent(Replace.class)) continue;
            replacingClasses.add(c);
            Class<T> tmpClass = c;
            do {
                tmpClass = tmpClass.getSuperclass();
                replacedClasses.add(tmpClass);
            } while (tmpClass.isAnnotationPresent(Replace.class));
        }
        if (replacingClasses.isEmpty()) {
            return replacingClasses;
        }
        replacingClasses.removeAll(replacedClasses);
        return replacingClasses;
    }

    private static <T> boolean moveBefore(List<T> list, T element, T referenceElement) {
        int index = list.indexOf(referenceElement);
        if (index != -1) {
            list.remove(element);
            list.add(index, element);
            return true;
        }
        return false;
    }

    public static String getAnnotatedClassIdWithFallback(Class<?> clazz) {
        return ConfigurationUtility.getAnnotatedClassIdWithFallback(clazz, false);
    }

    public static String getAnnotatedClassIdWithFallback(Class<?> clazz, boolean simpleName) {
        String annotatedClassId;
        Class<?> replaced = ConfigurationUtility.getOriginalClass(clazz);
        ClassId id = replaced.getAnnotation(ClassId.class);
        String string = annotatedClassId = id == null ? null : id.value();
        if (annotatedClassId != null) {
            return annotatedClassId;
        }
        if (simpleName && !StringUtility.isNullOrEmpty(replaced.getSimpleName())) {
            return replaced.getSimpleName();
        }
        return replaced.getName();
    }

    public static Class<?> getOriginalClass(Class<?> c) {
        while (c.isAnnotationPresent(Replace.class)) {
            c = c.getSuperclass();
        }
        return c;
    }
}

