/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.logger;

import ch.qos.logback.classic.Level;
import org.eclipse.scout.rt.platform.logger.AbstractLoggerSupport;
import org.eclipse.scout.rt.platform.logger.ILoggerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackLoggerSupport
extends AbstractLoggerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(LogbackLoggerSupport.class);

    @Override
    public ILoggerSupport.LogLevel getLogLevel(String name) {
        return this.getLogLevel(LoggerFactory.getLogger((String)name));
    }

    @Override
    public ILoggerSupport.LogLevel getLogLevel(Logger logger) {
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)logger;
        Level logbackLevel = logbackLogger.getLevel();
        return this.logbackToScoutLevel(logbackLevel);
    }

    @Override
    public void setLogLevel(String name, ILoggerSupport.LogLevel level) {
        this.setLogLevel(LoggerFactory.getLogger((String)name), level);
    }

    @Override
    public void setLogLevel(Logger logger, ILoggerSupport.LogLevel level) {
        Level logbackLevel = this.scoutToLogbackLevel(level);
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)logger;
        logbackLogger.setLevel(logbackLevel);
    }

    protected ILoggerSupport.LogLevel logbackToScoutLevel(Level level) {
        if (level == null) {
            return null;
        }
        switch (level.toInt()) {
            case -2147483648: {
                return ILoggerSupport.LogLevel.ALL;
            }
            case 5000: {
                return ILoggerSupport.LogLevel.TRACE;
            }
            case 10000: {
                return ILoggerSupport.LogLevel.DEBUG;
            }
            case 20000: {
                return ILoggerSupport.LogLevel.INFO;
            }
            case 30000: {
                return ILoggerSupport.LogLevel.WARN;
            }
            case 40000: {
                return ILoggerSupport.LogLevel.ERROR;
            }
            case 0x7FFFFFFF: {
                return ILoggerSupport.LogLevel.OFF;
            }
        }
        LOG.info("unknown log4j level '{}'. Falling back to scout log level '{}'", (Object)level, (Object)ILoggerSupport.LogLevel.WARN);
        return ILoggerSupport.LogLevel.WARN;
    }

    protected Level scoutToLogbackLevel(ILoggerSupport.LogLevel level) {
        if (level == null) {
            return null;
        }
        switch (level) {
            case ALL: {
                return Level.ALL;
            }
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case OFF: {
                return Level.OFF;
            }
        }
        LOG.info("unknown scout log level '{}'. Falling back to log4j level '{}'", (Object)level, (Object)Level.WARN);
        return Level.WARN;
    }
}

