/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.logger;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.scout.rt.platform.logger.AbstractLoggerSupport;
import org.eclipse.scout.rt.platform.logger.ILoggerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JulLoggerSupport
extends AbstractLoggerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JulLoggerSupport.class);
    private final Map<Level, ILoggerSupport.LogLevel> m_julToScoutLevelMap = new HashMap<Level, ILoggerSupport.LogLevel>();

    public JulLoggerSupport() {
        this.registerLevelMappings(this.m_julToScoutLevelMap);
    }

    protected void registerLevelMappings(Map<Level, ILoggerSupport.LogLevel> julToScoutLevelMap) {
        julToScoutLevelMap.put(Level.ALL, ILoggerSupport.LogLevel.ALL);
        julToScoutLevelMap.put(Level.FINEST, ILoggerSupport.LogLevel.TRACE);
        julToScoutLevelMap.put(Level.FINER, ILoggerSupport.LogLevel.DEBUG);
        julToScoutLevelMap.put(Level.FINE, ILoggerSupport.LogLevel.DEBUG);
        julToScoutLevelMap.put(Level.CONFIG, ILoggerSupport.LogLevel.INFO);
        julToScoutLevelMap.put(Level.INFO, ILoggerSupport.LogLevel.INFO);
        julToScoutLevelMap.put(Level.WARNING, ILoggerSupport.LogLevel.WARN);
        julToScoutLevelMap.put(Level.SEVERE, ILoggerSupport.LogLevel.ERROR);
        julToScoutLevelMap.put(Level.OFF, ILoggerSupport.LogLevel.OFF);
    }

    @Override
    public ILoggerSupport.LogLevel getLogLevel(String name) {
        java.util.logging.Logger julLogger = this.getJulLogger(name);
        Level julLevel = julLogger.getLevel();
        return this.julToScoutLevel(julLevel);
    }

    @Override
    public void setLogLevel(String name, ILoggerSupport.LogLevel level) {
        Level julLevel = this.scoutToJulLevel(level);
        java.util.logging.Logger julLogger = this.getJulLogger(name);
        julLogger.setLevel(julLevel);
    }

    protected java.util.logging.Logger getJulLogger(String name) {
        if (name.equalsIgnoreCase("ROOT")) {
            name = "";
        }
        return java.util.logging.Logger.getLogger(name);
    }

    protected ILoggerSupport.LogLevel julToScoutLevel(Level level) {
        if (level == null) {
            return null;
        }
        ILoggerSupport.LogLevel l = this.m_julToScoutLevelMap.get(level);
        if (l == null) {
            LOG.info("unknown jul level '{}'. Falling back to scout log level '{}'", (Object)level, (Object)ILoggerSupport.LogLevel.WARN);
            l = ILoggerSupport.LogLevel.WARN;
        }
        return l;
    }

    protected Level scoutToJulLevel(ILoggerSupport.LogLevel level) {
        if (level == null) {
            return null;
        }
        switch (level) {
            case ALL: {
                return Level.ALL;
            }
            case TRACE: {
                return Level.FINEST;
            }
            case DEBUG: {
                return Level.FINE;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARNING;
            }
            case ERROR: {
                return Level.SEVERE;
            }
            case OFF: {
                return Level.OFF;
            }
        }
        LOG.info("unknown scout log level '{}'. Falling back to jul level '{}'", (Object)level, (Object)Level.WARNING);
        return Level.WARNING;
    }
}

