/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.logger;

import org.eclipse.scout.rt.platform.chain.callable.ICallableDecorator;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.slf4j.MDC;

public class DiagnosticContextValueProcessor
implements ICallableDecorator {
    private final IDiagnosticContextValueProvider m_mdcValueProvider;
    private final String m_mdcKey;

    public DiagnosticContextValueProcessor(IDiagnosticContextValueProvider mdcValueProvider) {
        this.m_mdcValueProvider = mdcValueProvider;
        this.m_mdcKey = Assertions.assertNotNullOrEmpty(mdcValueProvider.key(), "MDC key must not be null", new Object[0]);
    }

    @Override
    public ICallableDecorator.IUndecorator decorate() throws Exception {
        String originValue = MDC.get((String)this.m_mdcKey);
        DiagnosticContextValueProcessor.putOrRemoveMdcValue(this.m_mdcKey, this.m_mdcValueProvider.value());
        return () -> DiagnosticContextValueProcessor.putOrRemoveMdcValue(this.m_mdcKey, originValue);
    }

    public String getMdcKey() {
        return this.m_mdcKey;
    }

    private static void putOrRemoveMdcValue(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        } else {
            MDC.remove((String)key);
        }
    }

    public static interface IDiagnosticContextValueProvider {
        public String key();

        public String value();
    }
}

