/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.listener;

import java.util.EventObject;
import org.eclipse.scout.rt.platform.job.IJobManager;
import org.eclipse.scout.rt.platform.job.listener.JobEventData;
import org.eclipse.scout.rt.platform.job.listener.JobEventType;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;

public class JobEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private final JobEventType m_type;
    private final transient JobEventData m_data;

    public JobEvent(IJobManager jobManager, JobEventType type, JobEventData data) {
        super(jobManager);
        this.m_type = Assertions.assertNotNull(type, "missing jobEventType", new Object[0]);
        this.m_data = Assertions.assertNotNull(data, "missing jobEventData", new Object[0]);
    }

    @Override
    public IJobManager getSource() {
        return (IJobManager)super.getSource();
    }

    public JobEventType getType() {
        return this.m_type;
    }

    public JobEventData getData() {
        return this.m_data;
    }

    @Override
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.attr("type", this.m_type.name());
        builder.attr("data", (Object)this.m_data);
        builder.ref("source", this.getSource());
        return builder.toString();
    }
}

