/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.platform.chain.callable.CallableChain;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.config.PlatformConfigProperties;
import org.eclipse.scout.rt.platform.context.RunContextRunner;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.job.IBlockingCondition;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.IJobManager;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.JobState;
import org.eclipse.scout.rt.platform.job.internal.BlockingCondition;
import org.eclipse.scout.rt.platform.job.internal.CallableChainExceptionHandler;
import org.eclipse.scout.rt.platform.job.internal.CompletionPromise;
import org.eclipse.scout.rt.platform.job.internal.DelayedExecutor;
import org.eclipse.scout.rt.platform.job.internal.ExceptionProcessor;
import org.eclipse.scout.rt.platform.job.internal.ExecutionSemaphore;
import org.eclipse.scout.rt.platform.job.internal.FutureRunner;
import org.eclipse.scout.rt.platform.job.internal.FutureSet;
import org.eclipse.scout.rt.platform.job.internal.IRejectableRunnable;
import org.eclipse.scout.rt.platform.job.internal.JobExceptionTranslator;
import org.eclipse.scout.rt.platform.job.internal.JobFutureTask;
import org.eclipse.scout.rt.platform.job.internal.JobListeners;
import org.eclipse.scout.rt.platform.job.internal.JobNameContextValueProvider;
import org.eclipse.scout.rt.platform.job.internal.NamedThreadFactory;
import org.eclipse.scout.rt.platform.job.internal.ThreadNameDecorator;
import org.eclipse.scout.rt.platform.job.listener.IJobListener;
import org.eclipse.scout.rt.platform.job.listener.JobEvent;
import org.eclipse.scout.rt.platform.job.listener.JobEventData;
import org.eclipse.scout.rt.platform.job.listener.JobEventType;
import org.eclipse.scout.rt.platform.logger.DiagnosticContextValueProcessor;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;
import org.eclipse.scout.rt.platform.util.ThreadLocalProcessor;
import org.eclipse.scout.rt.platform.util.concurrent.Callables;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JobManager
implements IJobManager {
    private static final Logger LOG = LoggerFactory.getLogger(JobManager.class);
    protected final ExecutorService m_executor = this.createExecutor();
    protected final DelayedExecutor m_delayedExecutor = new DelayedExecutor(this.m_executor, "scout-scheduler-thread");
    protected final FutureSet m_futures;
    protected final JobListeners m_listeners = BEANS.get(JobListeners.class);
    protected final ReentrantReadWriteLock m_shutdownLock;
    protected volatile boolean m_shutdown;

    public JobManager() {
        this.m_futures = BEANS.get(FutureSet.class);
        this.m_futures.init(this);
        this.m_shutdownLock = new ReentrantReadWriteLock();
    }

    @Override
    public final IFuture<Void> schedule(IRunnable runnable, JobInput input) {
        return this.schedule(Callables.callable(runnable), this.ensureJobInputName(input, runnable.getClass().getName()));
    }

    @Override
    public final <RESULT> IFuture<RESULT> schedule(Callable<RESULT> callable, JobInput input) {
        Assertions.assertNotNull(input, "JobInput must not be null", new Object[0]);
        Assertions.assertFalse(this.isShutdown(), "{} not available because the platform has been shut down.", this.getClass().getSimpleName());
        JobFutureTask<RESULT> futureTask = this.createJobFutureTask(callable, input);
        this.submit(futureTask);
        return futureTask;
    }

    protected <RESULT> void submit(JobFutureTask<RESULT> futureTask) {
        try {
            futureTask.changeState(JobState.SCHEDULED);
            if (futureTask.isSingleExecution() && !futureTask.isDelayedExecution()) {
                this.competeForPermitAndExecute(futureTask, futureTask);
            } else {
                if (futureTask.isDelayedExecution()) {
                    futureTask.changeState(JobState.PENDING);
                }
                this.m_delayedExecutor.schedule(() -> this.competeForPermitAndExecute(futureTask, new FutureRunner(this, futureTask)), futureTask.getFirstFireTime());
            }
        }
        catch (Error | RuntimeException e) {
            futureTask.reject();
            throw e;
        }
    }

    protected void competeForPermitAndExecute(JobFutureTask<?> futureTask, IRejectableRunnable futureRunner) {
        ExecutionSemaphore executionSemaphore = futureTask.getExecutionSemaphore();
        if (executionSemaphore == null) {
            this.m_executor.execute(futureRunner);
        } else {
            futureTask.changeState(JobState.WAITING_FOR_PERMIT);
            executionSemaphore.compete(futureTask, ExecutionSemaphore.QueuePosition.TAIL, () -> this.m_executor.execute(futureRunner));
        }
    }

    @Override
    public boolean isDone(Predicate<IFuture<?>> filter) {
        return this.m_futures.matchesEvery(filter, CompletionPromise.FUTURE_DONE_MATCHER);
    }

    @Override
    public void awaitDone(Predicate<IFuture<?>> filter, long timeout, TimeUnit unit) {
        try {
            this.m_futures.awaitDone(filter, timeout, unit);
        }
        catch (TimeoutException e) {
            throw BEANS.get(JobExceptionTranslator.class).translateTimeoutException(e, "Failed to wait for jobs to complete because the maximal wait time elapsed", timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw BEANS.get(JobExceptionTranslator.class).translateInterruptedException(e, "Interrupted while waiting for jobs to complete");
        }
    }

    @Override
    public void awaitFinished(Predicate<IFuture<?>> filter, long timeout, TimeUnit unit) {
        try {
            this.m_futures.awaitFinished(filter, timeout, unit);
        }
        catch (TimeoutException e) {
            throw BEANS.get(JobExceptionTranslator.class).translateTimeoutException(e, "Failed to wait for jobs to complete because the maximal wait time elapsed", timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw BEANS.get(JobExceptionTranslator.class).translateInterruptedException(e, "Interrupted while waiting for jobs to complete");
        }
    }

    @Override
    public boolean cancel(Predicate<IFuture<?>> filter, boolean interruptIfRunning) {
        return this.m_futures.cancel(filter, interruptIfRunning);
    }

    @Override
    public boolean isShutdown() {
        return this.m_shutdown;
    }

    @Override
    public final void shutdown() {
        LOG.debug("JobManager shutting down.");
        this.m_shutdownLock.writeLock().lock();
        try {
            this.m_shutdown = true;
        }
        finally {
            this.m_shutdownLock.writeLock().unlock();
        }
        this.m_futures.dispose();
        this.shutdownExecutor(this.m_executor);
        this.fireEvent(new JobEvent(this, JobEventType.JOB_MANAGER_SHUTDOWN, new JobEventData()));
    }

    @Override
    public Set<IFuture<?>> getFutures(Predicate<IFuture<?>> filter) {
        return this.m_futures.values(filter);
    }

    @Override
    public IRegistrationHandle addListener(IJobListener listener) {
        return this.addListener(null, listener);
    }

    @Override
    public IRegistrationHandle addListener(Predicate<JobEvent> filter, IJobListener listener) {
        return this.m_listeners.add(filter, listener);
    }

    protected void fireEvent(JobEvent eventToFire) {
        this.m_listeners.notifyListeners(eventToFire);
    }

    protected <RESULT> JobFutureTask<RESULT> createJobFutureTask(Callable<RESULT> callable, JobInput input) {
        RunMonitor runMonitor = Assertions.assertNotNull(input.getRunContext() != null ? input.getRunContext().getRunMonitor() : BEANS.get(RunMonitor.class), "'RunMonitor' required if providing a 'RunContext'", new Object[0]);
        JobInput inputCopy = this.ensureJobInputName(input, callable.getClass().getName());
        return new JobFutureTask(this, runMonitor, inputCopy, new CallableChain(), callable);
    }

    protected ExecutorService createExecutor() {
        int corePoolSize = (Integer)CONFIG.getPropertyValue(PlatformConfigProperties.JobManagerCorePoolSizeProperty.class);
        int maximumPoolSize = (Integer)CONFIG.getPropertyValue(PlatformConfigProperties.JobManagerMaximumPoolSizeProperty.class);
        long keepAliveTime = (Long)CONFIG.getPropertyValue(PlatformConfigProperties.JobManagerKeepAliveTimeProperty.class);
        boolean allowCoreThreadTimeOut = (Boolean)CONFIG.getPropertyValue(PlatformConfigProperties.JobManagerAllowCoreThreadTimeoutProperty.class);
        boolean prestartCoreThreads = (Boolean)CONFIG.getPropertyValue(PlatformConfigProperties.JobManagerPrestartCoreThreadsProperty.class);
        RejectedExecutionHandler rejectHandler = (runnable, executor) -> {
            if (this.isShutdown()) {
                LOG.debug("Job rejected because the job manager is shutdown.");
            } else {
                LOG.error("Job rejected because no more threads or queue slots available. [runnable={}]", (Object)runnable);
            }
            if (runnable instanceof IRejectableRunnable) {
                ((IRejectableRunnable)runnable).reject();
            }
        };
        ThreadPoolExecutor executor2 = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory("scout-thread"), rejectHandler);
        executor2.allowCoreThreadTimeOut(allowCoreThreadTimeOut);
        if (prestartCoreThreads) {
            executor2.prestartAllCoreThreads();
        }
        return executor2;
    }

    public ExecutorService getExecutor() {
        return this.m_executor;
    }

    protected DelayedExecutor getDelayedExecutor() {
        return this.m_delayedExecutor;
    }

    protected void shutdownExecutor(ExecutorService executor) {
        executor.shutdownNow();
        try {
            executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected <RESULT> void interceptCallableChain(CallableChain<RESULT> callableChain, JobFutureTask<?> future, RunMonitor runMonitor, JobInput input) {
        callableChain.add(new CallableChainExceptionHandler()).add(new ThreadLocalProcessor(IFuture.CURRENT, future)).add(new ThreadLocalProcessor<RunMonitor>(RunMonitor.CURRENT, runMonitor)).add(BEANS.get(ThreadNameDecorator.class)).add(new DiagnosticContextValueProcessor(BEANS.get(JobNameContextValueProvider.class))).add(new RunContextRunner(input.getRunContext())).add(new ExceptionProcessor(input));
    }

    @Override
    public IBlockingCondition newBlockingCondition(boolean blocking) {
        return new BlockingCondition(blocking);
    }

    protected void registerFuture(JobFutureTask<?> future) {
        this.m_shutdownLock.readLock().lock();
        try {
            Assertions.assertFalse(this.isShutdown(), "{} not available because the platform has been shut down.", this.getClass().getSimpleName());
            this.m_futures.add(future);
        }
        finally {
            this.m_shutdownLock.readLock().unlock();
        }
    }

    protected void unregisterFuture(JobFutureTask<?> future) {
        this.m_futures.remove(future);
    }

    protected JobInput ensureJobInputName(JobInput input, String defaultName) {
        if (input != null && input.getName() == null) {
            return input.copy().withName(defaultName, new Object[0]);
        }
        return input;
    }

    @Order(value=5900.0)
    public static class PlatformListener
    implements IPlatformListener {
        @Override
        public void stateChanged(PlatformEvent event) {
            if (event.getState() == IPlatform.State.PlatformStopping) {
                BEANS.get(JobManager.class).shutdown();
            }
        }
    }
}

