/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.chain.callable.CallableChain;
import org.eclipse.scout.rt.platform.chain.callable.ICallableInterceptor;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.exception.DefaultRuntimeExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.IExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.IThrowableWithContextInfo;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.job.DoneEvent;
import org.eclipse.scout.rt.platform.job.ExecutionTrigger;
import org.eclipse.scout.rt.platform.job.IDoneHandler;
import org.eclipse.scout.rt.platform.job.IExecutionSemaphore;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.JobState;
import org.eclipse.scout.rt.platform.job.internal.CompletionPromise;
import org.eclipse.scout.rt.platform.job.internal.ExecutionSemaphore;
import org.eclipse.scout.rt.platform.job.internal.IRejectableRunnable;
import org.eclipse.scout.rt.platform.job.internal.JobExceptionTranslator;
import org.eclipse.scout.rt.platform.job.internal.JobListenerWithFilter;
import org.eclipse.scout.rt.platform.job.internal.JobManager;
import org.eclipse.scout.rt.platform.job.listener.IJobListener;
import org.eclipse.scout.rt.platform.job.listener.JobEvent;
import org.eclipse.scout.rt.platform.job.listener.JobEventData;
import org.eclipse.scout.rt.platform.job.listener.JobEventType;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;
import org.quartz.Calendar;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.spi.OperableTrigger;

public class JobFutureTask<RESULT>
extends FutureTask<RESULT>
implements IFuture<RESULT>,
IRejectableRunnable {
    protected final JobManager m_jobManager;
    protected final RunMonitor m_runMonitor;
    protected final JobInput m_input;
    protected final Long m_expirationDate;
    protected final ExecutionSemaphore m_executionSemaphore;
    protected final CallableChain<RESULT> m_callableChain;
    protected final List<JobListenerWithFilter> m_listeners = new CopyOnWriteArrayList<JobListenerWithFilter>();
    protected volatile JobState m_state = JobState.NEW;
    protected final CompletionPromise<RESULT> m_completionPromise;
    protected final AtomicBoolean m_finished = new AtomicBoolean(false);
    protected volatile Set<String> m_executionHints = new HashSet<String>();
    protected final Date m_firstFireTime;
    protected final boolean m_singleExecution;
    protected final boolean m_delayedExecution;
    protected final OperableTrigger m_trigger;
    protected final Calendar m_calendar;
    protected volatile Thread m_runner;

    public JobFutureTask(JobManager jobManager, RunMonitor runMonitor, JobInput input, CallableChain<RESULT> callableChain, Callable<RESULT> callable) {
        super(() -> callableChain.call(callable));
        this.m_jobManager = jobManager;
        this.m_runMonitor = runMonitor;
        this.m_input = input;
        this.m_executionSemaphore = ExecutionSemaphore.get(input);
        this.m_callableChain = callableChain;
        this.m_completionPromise = new CompletionPromise(this, jobManager.getExecutor());
        this.m_expirationDate = input.getExpirationTimeMillis() != 0L ? Long.valueOf(System.currentTimeMillis() + input.getExpirationTimeMillis()) : null;
        this.m_executionHints.addAll(input.getExecutionHints());
        this.m_jobManager.interceptCallableChain(this.m_callableChain, this, this.m_runMonitor, this.m_input);
        this.m_callableChain.addLast(new ICallableInterceptor<RESULT>(){

            @Override
            public RESULT intercept(CallableChain.Chain<RESULT> chain) throws Exception {
                return null;
            }

            @Override
            public boolean isEnabled() {
                return JobFutureTask.this.m_runMonitor.isCancelled();
            }
        });
        this.m_callableChain.addLast(() -> {
            this.changeState(JobState.RUNNING);
            return null;
        });
        this.m_trigger = this.createQuartzTrigger(input);
        this.m_calendar = input.getExecutionTrigger() == null ? null : input.getExecutionTrigger().getCalendar();
        this.m_firstFireTime = this.computeFirstFireTime(this.m_trigger);
        this.m_singleExecution = this.computeSingleExecuting((Trigger)this.m_trigger, this.m_firstFireTime);
        this.m_delayedExecution = input.getExecutionTrigger() == null ? false : this.computeDelayedExecuting(this.m_firstFireTime, this.m_input.getExecutionTrigger().getNow());
        this.m_jobManager.registerFuture(this);
        this.m_runMonitor.registerCancellable(this);
    }

    @Override
    public void run() {
        this.m_trigger.triggered(this.m_calendar);
        this.m_runner = Thread.currentThread();
        try {
            if (this.isExpired()) {
                this.cancel(true);
            } else if (this.isFinalRun()) {
                super.run();
            } else {
                super.runAndReset();
            }
        }
        finally {
            this.m_runner = null;
            this.finishInternal();
            this.releasePermit();
        }
    }

    @Override
    protected void done() {
        this.changeState(JobState.DONE);
        this.m_listeners.clear();
        this.m_runMonitor.unregisterCancellable(this);
        this.m_completionPromise.done();
        this.finishInternal();
    }

    protected void cancelled(boolean interruptIfRunning) {
        Thread runner;
        this.m_runMonitor.cancel(interruptIfRunning);
        if (interruptIfRunning && this.m_input.getRunContext() == null && (runner = this.m_runner) != null) {
            runner.interrupt();
        }
    }

    protected void finished() {
        this.m_jobManager.unregisterFuture(this);
        this.m_completionPromise.finish();
    }

    @Override
    public final void reject() {
        this.changeState(JobState.REJECTED);
        this.cancel(true);
        this.releasePermit();
    }

    @Override
    public boolean isSingleExecution() {
        return this.m_singleExecution;
    }

    protected boolean isDelayedExecution() {
        return this.m_delayedExecution;
    }

    protected boolean hasNextExecution() {
        return this.m_trigger.mayFireAgain();
    }

    public Date getFirstFireTime() {
        return this.m_firstFireTime;
    }

    protected OperableTrigger getTrigger() {
        return this.m_trigger;
    }

    protected Calendar getCalendar() {
        return this.m_calendar;
    }

    @Override
    public ExecutionSemaphore getExecutionSemaphore() {
        return this.m_executionSemaphore;
    }

    @Override
    public JobInput getJobInput() {
        return this.m_input;
    }

    @Override
    public JobState getState() {
        return this.m_state;
    }

    @Override
    public boolean addExecutionHint(String hint) {
        try {
            boolean bl = this.m_executionHints.add(hint);
            return bl;
        }
        finally {
            this.m_jobManager.fireEvent(new JobEvent(this.m_jobManager, JobEventType.JOB_EXECUTION_HINT_ADDED, new JobEventData().withFuture(this).withExecutionHint(hint)));
        }
    }

    @Override
    public boolean removeExecutionHint(String hint) {
        try {
            boolean bl = this.m_executionHints.remove(hint);
            return bl;
        }
        finally {
            this.m_jobManager.fireEvent(new JobEvent(this.m_jobManager, JobEventType.JOB_EXECUTION_HINT_REMOVED, new JobEventData().withFuture(this).withExecutionHint(hint)));
        }
    }

    @Override
    public boolean containsExecutionHint(String hint) {
        return this.m_executionHints.contains(hint);
    }

    protected boolean isExpired() {
        return this.m_expirationDate == null ? false : System.currentTimeMillis() > this.m_expirationDate;
    }

    @Override
    public boolean isFinished() {
        return this.m_completionPromise.isFinished();
    }

    @Override
    public boolean cancel(boolean interruptIfRunning) {
        if (super.cancel(false)) {
            this.cancelled(interruptIfRunning);
            return true;
        }
        return false;
    }

    @Override
    public void awaitDone() {
        this.assertNotSameSemaphore();
        try {
            this.m_completionPromise.awaitDoneAndGet();
        }
        catch (CancellationException | ExecutionException exception) {
        }
        catch (InterruptedException e) {
            this.restoreInterruptionStatus();
            throw this.interceptException(BEANS.get(JobExceptionTranslator.class).translateInterruptedException(e, "Interrupted while waiting for a job to complete"));
        }
    }

    @Override
    public void awaitDone(long timeout, TimeUnit unit) {
        this.assertNotSameSemaphore();
        try {
            this.m_completionPromise.awaitDoneAndGet(timeout, unit);
        }
        catch (CancellationException | ExecutionException exception) {
        }
        catch (InterruptedException e) {
            this.restoreInterruptionStatus();
            throw this.interceptException(BEANS.get(JobExceptionTranslator.class).translateInterruptedException(e, "Interrupted while waiting for a job to complete"));
        }
        catch (TimeoutException e) {
            throw this.interceptException(BEANS.get(JobExceptionTranslator.class).translateTimeoutException(e, "Failed to wait for a job to complete because the maximal wait time elapsed", timeout, unit));
        }
    }

    @Override
    public void awaitFinished(long timeout, TimeUnit unit) {
        this.assertNotSameSemaphore();
        try {
            this.m_completionPromise.awaitFinished(timeout, unit);
        }
        catch (InterruptedException e) {
            this.restoreInterruptionStatus();
            throw this.interceptException(BEANS.get(JobExceptionTranslator.class).translateInterruptedException(e, "Interrupted while waiting for a job to finish"));
        }
        catch (TimeoutException e) {
            throw this.interceptException(BEANS.get(JobExceptionTranslator.class).translateTimeoutException(e, "Failed to wait for a job to finish because the maximal wait time elapsed", timeout, unit));
        }
    }

    @Override
    public RESULT awaitDoneAndGet() {
        return this.awaitDoneAndGet(DefaultRuntimeExceptionTranslator.class);
    }

    @Override
    public <EXCEPTION extends Throwable> RESULT awaitDoneAndGet(Class<? extends IExceptionTranslator<EXCEPTION>> exceptionTranslator) throws EXCEPTION {
        this.assertNotSameSemaphore();
        try {
            return this.m_completionPromise.awaitDoneAndGet();
        }
        catch (ExecutionException e) {
            throw this.interceptException(BEANS.get(JobExceptionTranslator.class).translateExecutionException(e, exceptionTranslator));
        }
        catch (CancellationException e) {
            throw this.interceptException(BEANS.get(JobExceptionTranslator.class).translateCancellationException(e, "Failed to wait for a job to complete because the job was cancelled"));
        }
        catch (InterruptedException e) {
            this.restoreInterruptionStatus();
            throw this.interceptException(BEANS.get(JobExceptionTranslator.class).translateInterruptedException(e, "Interrupted while waiting for a job to complete"));
        }
    }

    @Override
    public RESULT awaitDoneAndGet(long timeout, TimeUnit unit) {
        return this.awaitDoneAndGet(timeout, unit, DefaultRuntimeExceptionTranslator.class);
    }

    @Override
    public <EXCEPTION extends Throwable> RESULT awaitDoneAndGet(long timeout, TimeUnit unit, Class<? extends IExceptionTranslator<EXCEPTION>> exceptionTranslator) throws EXCEPTION {
        this.assertNotSameSemaphore();
        try {
            return this.m_completionPromise.awaitDoneAndGet(timeout, unit);
        }
        catch (ExecutionException e) {
            throw this.interceptException(BEANS.get(JobExceptionTranslator.class).translateExecutionException(e, exceptionTranslator));
        }
        catch (CancellationException e) {
            throw this.interceptException(BEANS.get(JobExceptionTranslator.class).translateCancellationException(e, "Failed to wait for a job to complete because the job was cancelled"));
        }
        catch (InterruptedException e) {
            this.restoreInterruptionStatus();
            throw this.interceptException(BEANS.get(JobExceptionTranslator.class).translateInterruptedException(e, "Interrupted while waiting for a job to complete"));
        }
        catch (TimeoutException e) {
            throw this.interceptException(BEANS.get(JobExceptionTranslator.class).translateTimeoutException(e, "Failed to wait for a job to complete because the maximal wait time elapsed", timeout, unit));
        }
    }

    @Override
    public IFuture<RESULT> whenDone(IDoneHandler<RESULT> callback, RunContext runContext) {
        this.m_completionPromise.whenDone(callback, runContext);
        return this;
    }

    @Override
    public <FUNCTION_RESULT> IFuture<FUNCTION_RESULT> whenDoneSchedule(BiFunction<RESULT, Throwable, FUNCTION_RESULT> function, JobInput input) {
        Assertions.assertNotNull(input, "Input must not be null", new Object[0]);
        Assertions.assertNotNull(function, "Function must not be null", new Object[0]);
        AtomicReference doneEvent = new AtomicReference();
        JobFutureTask<Object> functionFuture = this.m_jobManager.createJobFutureTask(() -> function.apply(((DoneEvent)doneEvent.get()).getResult(), ((DoneEvent)doneEvent.get()).getException()), input);
        this.whenDone(event -> {
            doneEvent.set(event);
            if (event.isCancelled()) {
                functionFuture.cancel(false);
            }
            this.m_jobManager.submit(functionFuture);
        }, null);
        return functionFuture;
    }

    @Override
    public IFuture<Void> whenDoneSchedule(BiConsumer<RESULT, Throwable> function, JobInput input) {
        return this.whenDoneSchedule((RESULT result, Throwable throwable) -> {
            function.accept((Object)result, (Throwable)throwable);
            return null;
        }, input);
    }

    @Override
    public IRegistrationHandle addListener(IJobListener listener) {
        return this.addListener(null, listener);
    }

    @Override
    public IRegistrationHandle addListener(Predicate<JobEvent> filter, IJobListener listener) {
        JobListenerWithFilter localListener = new JobListenerWithFilter(listener, filter);
        this.m_listeners.add(localListener);
        return () -> {
            boolean bl = this.m_listeners.remove(localListener);
        };
    }

    protected List<JobListenerWithFilter> getListeners() {
        return this.m_listeners;
    }

    protected CompletionPromise<RESULT> getCompletionPromise() {
        return this.m_completionPromise;
    }

    protected void assertNotSameSemaphore() {
        IFuture<?> currentFuture = IFuture.CURRENT.get();
        if (currentFuture == null) {
            return;
        }
        IExecutionSemaphore currentSemaphore = currentFuture.getJobInput().getExecutionSemaphore();
        if (currentSemaphore == null) {
            return;
        }
        if (!currentSemaphore.isPermitOwner(currentFuture)) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        Assertions.assertNotSame(currentSemaphore, this.m_executionSemaphore, "Potential deadlock detected: Cannot wait for a job which is assigned to the same semaphore as the current job [semaphore={}]", currentSemaphore);
    }

    protected void releasePermit() {
        if (this.m_executionSemaphore != null && this.m_executionSemaphore.isPermitOwner(this)) {
            this.m_executionSemaphore.release(this);
        }
    }

    protected void restoreInterruptionStatus() {
        Thread.currentThread().interrupt();
    }

    protected <EXCEPTION extends Throwable> EXCEPTION interceptException(EXCEPTION exception) {
        if (exception instanceof IThrowableWithContextInfo) {
            ((IThrowableWithContextInfo)((Object)exception)).withContextInfo("job", this.getJobInput().getName(), new Object[0]);
        }
        return exception;
    }

    protected void changeState(JobState state) {
        this.changeState(new JobEventData().withState(state).withFuture(this));
    }

    protected synchronized void changeState(JobEventData eventData) {
        Assertions.assertNotNull(eventData.getState(), "missing state", new Object[0]);
        Assertions.assertSame(this, eventData.getFuture(), "wrong future [expected={}]", this);
        if (this.m_state == eventData.getState()) {
            return;
        }
        if (this.m_state == JobState.DONE || this.m_state == JobState.REJECTED) {
            return;
        }
        this.m_state = eventData.getState();
        this.m_jobManager.fireEvent(new JobEvent(this.m_jobManager, JobEventType.JOB_STATE_CHANGED, eventData));
    }

    @Override
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.attr("job", this.m_input.getName());
        builder.attr("state", (Object)this.m_state);
        return builder.toString();
    }

    protected boolean isFinalRun() {
        if (this.isSingleExecution()) {
            return true;
        }
        return !this.hasNextExecution();
    }

    private void finishInternal() {
        if (this.m_runner != null) {
            return;
        }
        if (!this.isDone()) {
            return;
        }
        if (!this.m_finished.compareAndSet(false, true)) {
            return;
        }
        this.finished();
    }

    protected Date computeFirstFireTime(OperableTrigger trigger) {
        try {
            trigger.validate();
        }
        catch (SchedulerException e) {
            throw new PlatformException("Trigger not valid [trigger={}, job={}]", new Object[]{trigger, this, e});
        }
        Date firstFireDate = trigger.computeFirstFireTime(this.m_calendar);
        return Assertions.assertNotNull(firstFireDate, "Trigger not valid, because it will never fire. Check trigger's schedule. [schedule={}, future={}]", trigger.getScheduleBuilder(), this);
    }

    protected boolean computeSingleExecuting(Trigger trigger, Date firstFireTime) {
        if (trigger.getFinalFireTime() == null) {
            return false;
        }
        return trigger.getFinalFireTime().equals(firstFireTime);
    }

    protected boolean computeDelayedExecuting(Date firstFireTime, Date now) {
        return firstFireTime.after(now);
    }

    protected OperableTrigger createQuartzTrigger(JobInput input) {
        TriggerBuilder builder = TriggerBuilder.newTrigger().forJob(JobFutureTask.class.getSimpleName());
        ExecutionTrigger executionTrigger = input.getExecutionTrigger();
        if (executionTrigger != null) {
            builder.startAt(executionTrigger.getStartTime()).endAt(executionTrigger.getEndTime()).withSchedule(executionTrigger.getSchedule());
        }
        return (OperableTrigger)builder.build();
    }
}

