/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.chain.callable.CallableChain;
import org.eclipse.scout.rt.platform.chain.callable.ICallableInterceptor;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.internal.CallableChainHandledException;

public class ExceptionProcessor<RESULT>
implements ICallableInterceptor<RESULT> {
    protected final JobInput m_input;

    public ExceptionProcessor(JobInput input) {
        this.m_input = input;
    }

    @Override
    public RESULT intercept(CallableChain.Chain<RESULT> chain) throws Exception {
        try {
            return chain.continueChain();
        }
        catch (Error | Exception e) {
            boolean handled = false;
            if (this.m_input.getExceptionHandler() != null) {
                this.m_input.getExceptionHandler().handle(BEANS.get(DefaultExceptionTranslator.class).unwrap(e));
                handled = true;
            }
            if (!this.m_input.isSwallowException()) {
                if (handled) {
                    throw new CallableChainHandledException(e);
                }
                throw e;
            }
            return null;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.m_input.getExceptionHandler() != null || this.m_input.isSwallowException();
    }
}

