/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import java.util.Date;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DelayedExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DelayedExecutor.class);
    private final ExecutorService m_executor;
    private final String m_threadName;
    private final AtomicLong m_sequencer = new AtomicLong(-9223372036854775807L);
    private final DelayQueue<P_DelayedTask> m_delayedTaskQueue = new DelayQueue();

    DelayedExecutor(ExecutorService executor, String threadName) {
        this.m_executor = executor;
        this.m_threadName = threadName;
        this.m_executor.execute(new P_DispatchLoop());
    }

    public void schedule(Runnable runnable, Date fireTime) {
        Assertions.assertNotNull(fireTime, "FireTime must not be null", new Object[0]);
        this.m_delayedTaskQueue.put(new P_DelayedTask(runnable, fireTime));
    }

    private int signum(long value1, long value2) {
        return Long.compare(value1, value2);
    }

    static /* synthetic */ String access$0(DelayedExecutor delayedExecutor) {
        return delayedExecutor.m_threadName;
    }

    static /* synthetic */ ExecutorService access$1(DelayedExecutor delayedExecutor) {
        return delayedExecutor.m_executor;
    }

    static /* synthetic */ DelayQueue access$2(DelayedExecutor delayedExecutor) {
        return delayedExecutor.m_delayedTaskQueue;
    }

    static /* synthetic */ Logger access$3() {
        return LOG;
    }

    private class P_DelayedTask
    implements Delayed,
    Runnable {
        private final Runnable m_runnable;
        private final long m_executionTime;
        private final long m_sequenceNumber;

        P_DelayedTask(Runnable runnable, Date fireTime) {
            this.m_runnable = runnable;
            this.m_executionTime = fireTime.getTime();
            this.m_sequenceNumber = DelayedExecutor.this.m_sequencer.incrementAndGet();
        }

        @Override
        public void run() {
            this.m_runnable.run();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.m_executionTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            P_DelayedTask otherDelayedTask = (P_DelayedTask)other;
            int signum = DelayedExecutor.this.signum(this.m_executionTime, otherDelayedTask.m_executionTime);
            if (signum != 0) {
                return signum;
            }
            return DelayedExecutor.this.signum(this.m_sequenceNumber, otherDelayedTask.m_sequenceNumber);
        }
    }

    private class P_DispatchLoop
    implements Runnable {
        private P_DispatchLoop() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 7[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

