/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.eclipse.scout.rt.platform.job.DoneEvent;
import org.eclipse.scout.rt.platform.job.IDoneHandler;
import org.eclipse.scout.rt.platform.job.internal.JobFutureTask;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.FinalValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompletionPromise<RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(CompletionPromise.class);
    private final ExecutorService m_executor;
    private final Lock m_lock = new ReentrantLock();
    private final Condition m_doneCondition = this.m_lock.newCondition();
    private final Condition m_finishedCondition = this.m_lock.newCondition();
    private final JobFutureTask<RESULT> m_future;
    private final List<PromiseHandler<RESULT>> m_handlers;
    private final FinalValue<DoneEvent<RESULT>> m_doneEvent = new FinalValue();
    private final FinalValue<Boolean> m_finished = new FinalValue();
    static final Predicate<JobFutureTask<?>> FUTURE_DONE_MATCHER = FutureTask::isDone;
    static final Predicate<JobFutureTask<?>> PROMISE_DONE_MATCHER = future -> super.isDone();

    CompletionPromise(JobFutureTask<RESULT> future, ExecutorService executor) {
        this.m_future = future;
        this.m_handlers = new ArrayList<PromiseHandler<RESULT>>();
        this.m_executor = executor;
    }

    public void done() {
        this.m_lock.lock();
        try {
            this.m_doneEvent.set(CompletionPromise.newDoneEvent(this.m_future));
            this.m_doneCondition.signalAll();
        }
        finally {
            this.m_lock.unlock();
        }
        if (!this.m_handlers.isEmpty()) {
            this.m_executor.execute(() -> {
                Iterator<PromiseHandler<RESULT>> iterator = this.m_handlers.iterator();
                while (iterator.hasNext()) {
                    iterator.next().notifySafe(this.m_doneEvent.get());
                    iterator.remove();
                }
            });
        }
    }

    public void finish() {
        this.m_lock.lock();
        try {
            this.m_finished.set(Boolean.TRUE);
            this.m_finishedCondition.signalAll();
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public void whenDone(IDoneHandler<RESULT> handler, RunContext runContext) {
        boolean done;
        PromiseHandler<RESULT> promiseHandler = new PromiseHandler<RESULT>(handler, runContext);
        this.m_lock.lock();
        try {
            done = this.isDone();
            if (!done) {
                this.m_handlers.add(promiseHandler);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        if (done) {
            promiseHandler.notifySafe(this.m_doneEvent.get());
        }
    }

    public RESULT awaitDoneAndGet() throws InterruptedException, ExecutionException {
        this.m_lock.lockInterruptibly();
        try {
            while (!this.isDone()) {
                this.m_doneCondition.await();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return CompletionPromise.retrieveFinalValue(this.m_future);
    }

    public RESULT awaitDoneAndGet(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Assertions.assertGreater(timeout, 0L, "Invalid timeout; must be > 0 [timeout={}]", timeout);
        this.m_lock.lockInterruptibly();
        try {
            long nanos = unit.toNanos(timeout);
            while (!this.isDone() && nanos > 0L) {
                nanos = this.m_doneCondition.awaitNanos(nanos);
            }
            if (nanos <= 0L) {
                throw new TimeoutException(String.format("Waiting for the Future's final value timed out [timeout=%sms]", unit.toMillis(timeout)));
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return CompletionPromise.retrieveFinalValue(this.m_future);
    }

    public void awaitFinished(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Assertions.assertGreater(timeout, 0L, "Invalid timeout; must be > 0 [timeout={}]", timeout);
        this.m_lock.lockInterruptibly();
        try {
            long nanos = unit.toNanos(timeout);
            while (!this.isFinished() && nanos > 0L) {
                nanos = this.m_finishedCondition.awaitNanos(nanos);
            }
            if (nanos <= 0L) {
                throw new TimeoutException(String.format("Waiting for the Future to finish timed out [timeout=%sms]", unit.toMillis(timeout)));
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    Lock getInternalLock() {
        return this.m_lock;
    }

    private boolean isDone() {
        return this.m_doneEvent.isSet();
    }

    public boolean isFinished() {
        return this.m_finished.isSet();
    }

    private static <RESULT> RESULT retrieveFinalValue(Future<RESULT> future) throws ExecutionException {
        try {
            return future.get(0L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Unexpected: future expected to be in 'done' state", e);
        }
    }

    private static <RESULT> DoneEvent<RESULT> newDoneEvent(Future<RESULT> future) {
        try {
            return new DoneEvent<RESULT>(CompletionPromise.retrieveFinalValue(future), null, false);
        }
        catch (ExecutionException e) {
            return new DoneEvent<Object>(null, BEANS.get(DefaultExceptionTranslator.class).unwrap(e), false);
        }
        catch (CancellationException e) {
            return new DoneEvent<Object>(null, null, true);
        }
    }

    private static class PromiseHandler<RESULT> {
        private final RunContext m_runContext;
        private final IDoneHandler<RESULT> m_callback;

        PromiseHandler(IDoneHandler<RESULT> callback, RunContext runContext) {
            this.m_runContext = runContext;
            this.m_callback = callback;
        }

        public void notifySafe(DoneEvent<RESULT> doneEvent) {
            try {
                if (this.m_runContext == null) {
                    this.m_callback.onDone(doneEvent);
                } else {
                    this.m_runContext.run(() -> this.m_callback.onDone(doneEvent));
                }
            }
            catch (Throwable t) {
                LOG.error("Failed to notify 'done-promise' callback", t);
            }
        }
    }
}

