/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.scout.rt.platform.job.IBlockingCondition;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobState;
import org.eclipse.scout.rt.platform.job.internal.ExecutionSemaphore;
import org.eclipse.scout.rt.platform.job.internal.JobFutureTask;
import org.eclipse.scout.rt.platform.job.listener.JobEventData;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.platform.util.concurrent.TimedOutError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingCondition
implements IBlockingCondition {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingCondition.class);
    protected static final long TIMEOUT_INDEFINITELY = -1L;
    protected volatile boolean m_blocking;
    protected final Lock m_lock = new ReentrantLock();
    protected final Condition m_unblockedCondition = this.m_lock.newCondition();
    protected final Set<IRegistrationHandle> m_waitForHints = new HashSet<IRegistrationHandle>();

    protected BlockingCondition(boolean blocking) {
        this.m_blocking = blocking;
    }

    @Override
    public boolean isBlocking() {
        return this.m_blocking;
    }

    @Override
    public void setBlocking(boolean blocking) {
        if (this.m_blocking == blocking) {
            return;
        }
        this.m_lock.lock();
        try {
            if (this.m_blocking == blocking) {
                return;
            }
            this.m_blocking = blocking;
            if (!this.m_blocking) {
                this.m_unblockedCondition.signalAll();
            }
            Iterator<IRegistrationHandle> iterator = this.m_waitForHints.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
                iterator.remove();
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    @Override
    public void waitFor(String ... executionHints) {
        this.waitFor(-1L, TimeUnit.NANOSECONDS, executionHints);
    }

    @Override
    public void waitFor(long timeout, TimeUnit unit, String ... executionHints) {
        IFuture<?> currentFuture = IFuture.CURRENT.get();
        if (currentFuture instanceof JobFutureTask) {
            this.blockJobThread((JobFutureTask)currentFuture, timeout, unit, executionHints);
        } else {
            this.blockRegularThread(timeout, unit);
        }
    }

    protected void blockRegularThread(long timeout, TimeUnit unit) {
        if (!this.m_blocking) {
            return;
        }
        this.m_lock.lock();
        try {
            if (!this.m_blocking) {
                return;
            }
            this.awaitUntilSignaledOrTimeout(timeout, unit);
        }
        finally {
            this.m_lock.unlock();
        }
    }

    protected void blockJobThread(JobFutureTask<?> futureTask, long timeout, TimeUnit unit, String ... executionHints) {
        if (!this.m_blocking) {
            return;
        }
        IRegistrationHandle waitForHints = IRegistrationHandle.NULL_HANDLE;
        RuntimeException exceptionWhileWaiting = null;
        Error errorWhileWaiting = null;
        this.m_lock.lock();
        try {
            if (!this.m_blocking) {
                return;
            }
            waitForHints = this.registerWaitForHints(futureTask, executionHints);
            futureTask.changeState(new JobEventData().withState(JobState.WAITING_FOR_BLOCKING_CONDITION).withFuture(futureTask).withBlockingCondition(this));
            futureTask.releasePermit();
            try {
                this.awaitUntilSignaledOrTimeout(timeout, unit);
            }
            catch (RuntimeException e) {
                exceptionWhileWaiting = e;
            }
            catch (Error e) {
                errorWhileWaiting = e;
            }
        }
        finally {
            this.m_lock.unlock();
        }
        this.acquirePermitUninterruptibly(futureTask);
        waitForHints.dispose();
        futureTask.changeState(JobState.RUNNING);
        if (errorWhileWaiting != null) {
            throw errorWhileWaiting;
        }
        if (exceptionWhileWaiting != null) {
            throw exceptionWhileWaiting;
        }
    }

    protected void awaitUntilSignaledOrTimeout(long timeout, TimeUnit unit) {
        InterruptedException interrupted = null;
        this.m_lock.lock();
        try {
            try {
                if (timeout == -1L) {
                    while (this.m_blocking) {
                        this.m_unblockedCondition.await();
                    }
                } else {
                    long nanos = unit.toNanos(timeout);
                    while (this.m_blocking && nanos > 0L) {
                        nanos = this.m_unblockedCondition.awaitNanos(nanos);
                    }
                    if (nanos <= 0L) {
                        throw new TimedOutError("Timeout elapsed while waiting for a blocking condition to fall", new Object[0]).withContextInfo("blockingCondition", this, new Object[0]).withContextInfo("timeout", "{}ms", unit.toMillis(timeout)).withContextInfo("thread", Thread.currentThread().getName(), new Object[0]);
                    }
                }
            }
            catch (InterruptedException e) {
                interrupted = e;
                Thread.currentThread().interrupt();
            }
            if (interrupted != null || Thread.currentThread().isInterrupted()) {
                throw new ThreadInterruptedError("Interrupted while waiting for a blocking condition to fall", new Object[]{interrupted}).withContextInfo("blockingCondition", this, new Object[0]).withContextInfo("thread", Thread.currentThread().getName(), new Object[0]);
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    protected void acquirePermitUninterruptibly(JobFutureTask<?> futureTask) {
        ExecutionSemaphore semaphore = futureTask.getExecutionSemaphore();
        if (semaphore == null) {
            return;
        }
        futureTask.changeState(JobState.WAITING_FOR_PERMIT);
        boolean interrupted = Thread.interrupted();
        while (!semaphore.isPermitOwner(futureTask)) {
            try {
                semaphore.acquire(futureTask, ExecutionSemaphore.QueuePosition.HEAD);
            }
            catch (ThreadInterruptedError e) {
                interrupted = true;
                Thread.interrupted();
                LOG.info("Interrupted while acquiring semaphore permit. Continue to re-acquire the permit. [future={}, semaphore={}]", new Object[]{futureTask, semaphore, e});
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.attr("blocking", this.m_blocking);
        return builder.toString();
    }

    protected IRegistrationHandle registerWaitForHints(IFuture<?> future, String ... executionHints) {
        if (executionHints.length == 0) {
            return IRegistrationHandle.NULL_HANDLE;
        }
        HashSet<String> associatedExecutionHints = new HashSet<String>(executionHints.length);
        String[] stringArray = executionHints;
        int n = executionHints.length;
        int n2 = 0;
        while (n2 < n) {
            String executionHint = stringArray[n2];
            if (future.addExecutionHint(executionHint)) {
                associatedExecutionHints.add(executionHint);
            }
            ++n2;
        }
        AtomicBoolean disposed = new AtomicBoolean(false);
        IRegistrationHandle registrationHandle = () -> {
            if (!disposed.compareAndSet(false, true)) {
                return;
            }
            for (String associatedExecutionHint : associatedExecutionHints) {
                future.removeExecutionHint(associatedExecutionHint);
            }
        };
        this.m_waitForHints.add(registrationHandle);
        return registrationHandle;
    }
}

