/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.filter.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.filter.AndFilter;
import org.eclipse.scout.rt.platform.job.IExecutionSemaphore;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobState;
import org.eclipse.scout.rt.platform.job.filter.event.FutureFilterWrapperJobEventFilter;
import org.eclipse.scout.rt.platform.job.filter.event.JobEventFilter;
import org.eclipse.scout.rt.platform.job.filter.future.ExecutionHintFutureFilter;
import org.eclipse.scout.rt.platform.job.filter.future.ExecutionSemaphoreFutureFilter;
import org.eclipse.scout.rt.platform.job.filter.future.FutureFilter;
import org.eclipse.scout.rt.platform.job.filter.future.JobNameFutureFilter;
import org.eclipse.scout.rt.platform.job.filter.future.JobNameRegexFutureFilter;
import org.eclipse.scout.rt.platform.job.filter.future.JobStateFutureFilter;
import org.eclipse.scout.rt.platform.job.filter.future.RunContextFutureFilter;
import org.eclipse.scout.rt.platform.job.filter.future.SingleExecutionFutureFilter;
import org.eclipse.scout.rt.platform.job.listener.JobEvent;
import org.eclipse.scout.rt.platform.job.listener.JobEventType;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.IAdaptable;

@Bean
public class JobEventFilterBuilder {
    private final List<Predicate<JobEvent>> m_andFilters = new ArrayList<Predicate<JobEvent>>();

    public Predicate<JobEvent> toFilter() {
        switch (this.m_andFilters.size()) {
            case 0: {
                return future -> true;
            }
            case 1: {
                return this.m_andFilters.get(0);
            }
        }
        return new AdaptableAndFilter((Collection<Predicate<JobEvent>>)this.m_andFilters);
    }

    public JobEventFilterBuilder andMatch(Predicate<JobEvent> filter) {
        this.m_andFilters.add(filter);
        return this;
    }

    public JobEventFilterBuilder andMatchNot(Predicate<JobEvent> filter) {
        this.m_andFilters.add(Assertions.assertNotNull(filter, "Filter to negate must not be null", new Object[0]).negate());
        return this;
    }

    public JobEventFilterBuilder andMatchEventType(JobEventType ... eventTypes) {
        this.andMatch(new JobEventFilter(eventTypes));
        return this;
    }

    public JobEventFilterBuilder andMatchState(JobState ... states) {
        this.andMatch(new FutureFilterWrapperJobEventFilter(new JobStateFutureFilter(states)));
        return this;
    }

    public JobEventFilterBuilder andMatchName(String ... names) {
        this.andMatch(new FutureFilterWrapperJobEventFilter(new JobNameFutureFilter(names)));
        return this;
    }

    public JobEventFilterBuilder andMatchNameRegex(Pattern regex) {
        this.andMatch(new FutureFilterWrapperJobEventFilter(new JobNameRegexFutureFilter(regex)));
        return this;
    }

    public JobEventFilterBuilder andMatchFuture(IFuture<?> ... futures) {
        this.andMatch(new FutureFilterWrapperJobEventFilter(new FutureFilter(futures)));
        return this;
    }

    public JobEventFilterBuilder andMatchFuture(Collection<IFuture<?>> futures) {
        this.andMatch(new FutureFilterWrapperJobEventFilter(new FutureFilter(futures)));
        return this;
    }

    public <RESULT> JobEventFilterBuilder andMatchFuture(List<IFuture<RESULT>> futures) {
        this.andMatch(new FutureFilterWrapperJobEventFilter(new FutureFilter(futures.toArray(new IFuture[futures.size()]))));
        return this;
    }

    public JobEventFilterBuilder andMatchNotFuture(IFuture<?> ... futures) {
        this.andMatchNot(new FutureFilterWrapperJobEventFilter(new FutureFilter(futures)));
        return this;
    }

    public JobEventFilterBuilder andMatchNotFuture(Collection<IFuture<?>> futures) {
        this.andMatchNot(new FutureFilterWrapperJobEventFilter(new FutureFilter(futures)));
        return this;
    }

    public <RESULT> JobEventFilterBuilder andMatchNotFuture(List<IFuture<RESULT>> futures) {
        this.andMatchNot(new FutureFilterWrapperJobEventFilter(new FutureFilter(futures.toArray(new IFuture[futures.size()]))));
        return this;
    }

    public JobEventFilterBuilder andMatchExecutionSemaphore(IExecutionSemaphore semaphore) {
        this.andMatch(new FutureFilterWrapperJobEventFilter(new ExecutionSemaphoreFutureFilter(semaphore)));
        return this;
    }

    public JobEventFilterBuilder andAreSingleExecuting() {
        this.andMatch(new FutureFilterWrapperJobEventFilter(SingleExecutionFutureFilter.INSTANCE));
        return this;
    }

    public JobEventFilterBuilder andAreNotSingleExecuting() {
        this.andMatchNot(new FutureFilterWrapperJobEventFilter(SingleExecutionFutureFilter.INSTANCE));
        return this;
    }

    public JobEventFilterBuilder andMatchRunContext(Class<? extends RunContext> runContextClazz) {
        this.andMatch(new FutureFilterWrapperJobEventFilter(new RunContextFutureFilter(runContextClazz)));
        return this;
    }

    public JobEventFilterBuilder andMatchExecutionHint(String hint) {
        this.andMatch(new FutureFilterWrapperJobEventFilter(new ExecutionHintFutureFilter(hint)));
        return this;
    }

    public JobEventFilterBuilder andMatchNotExecutionHint(String hint) {
        this.andMatchNot(new FutureFilterWrapperJobEventFilter(new ExecutionHintFutureFilter(hint)));
        return this;
    }

    protected static class AdaptableAndFilter
    extends AndFilter<JobEvent>
    implements IAdaptable {
        private IFuture<?>[] m_futureIntersection = null;

        public AdaptableAndFilter(Collection<Predicate<JobEvent>> filters) {
            super(filters);
            this.m_futureIntersection = AdaptableAndFilter.calculateFutureIntersection(filters);
        }

        protected static IFuture<?>[] calculateFutureIntersection(Collection<Predicate<JobEvent>> filters) {
            ArrayList<IFuture> intersection = null;
            for (Predicate<JobEvent> filter : filters) {
                IFuture[] futures;
                if (!(filter instanceof IAdaptable) || (futures = ((IAdaptable)((Object)filter)).getAdapter(IFuture[].class)) == null) continue;
                if (intersection == null) {
                    intersection = new ArrayList<IFuture>(Arrays.asList(futures));
                } else {
                    intersection.retainAll(Arrays.asList(futures));
                }
                if (intersection.isEmpty()) break;
            }
            if (intersection == null || intersection.isEmpty()) {
                return null;
            }
            return intersection.toArray(new IFuture[intersection.size()]);
        }

        @Override
        public <T> T getAdapter(Class<T> adapterType) {
            if (adapterType == IFuture[].class) {
                return (T)this.m_futureIntersection;
            }
            return null;
        }
    }
}

