/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.job.ExecutionTrigger;
import org.eclipse.scout.rt.platform.job.IExecutionSemaphore;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;
import org.slf4j.helpers.MessageFormatter;

@Bean
public class JobInput {
    public static final long EXPIRE_NEVER = 0L;
    protected String m_name;
    protected IExecutionSemaphore m_executionSemaphore;
    protected long m_expirationTime = 0L;
    protected String m_threadName = "scout-thread";
    protected RunContext m_runContext;
    protected ExecutionTrigger m_executionTrigger;
    protected ExceptionHandler m_exceptionHandler = BEANS.get(ExceptionHandler.class);
    protected boolean m_swallowException = false;
    protected Set<String> m_executionHints = new HashSet<String>();

    public String getName() {
        return this.m_name;
    }

    public JobInput withName(String name, Object ... args) {
        this.m_name = MessageFormatter.arrayFormat((String)name, (Object[])args).getMessage();
        return this;
    }

    public ExecutionTrigger getExecutionTrigger() {
        return this.m_executionTrigger;
    }

    public JobInput withExecutionTrigger(ExecutionTrigger executionTrigger) {
        this.m_executionTrigger = executionTrigger;
        return this;
    }

    public IExecutionSemaphore getExecutionSemaphore() {
        return this.m_executionSemaphore;
    }

    public JobInput withExecutionSemaphore(IExecutionSemaphore executionSemaphore) {
        this.m_executionSemaphore = executionSemaphore;
        return this;
    }

    public long getExpirationTimeMillis() {
        return this.m_expirationTime;
    }

    public JobInput withExpirationTime(long time, TimeUnit timeUnit) {
        this.m_expirationTime = timeUnit.toMillis(time);
        return this;
    }

    public RunContext getRunContext() {
        return this.m_runContext;
    }

    public JobInput withRunContext(RunContext runContext) {
        this.m_runContext = runContext;
        return this;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.m_exceptionHandler;
    }

    public boolean isSwallowException() {
        return this.m_swallowException;
    }

    public JobInput withExceptionHandling(ExceptionHandler exceptionHandler, boolean swallowException) {
        this.m_exceptionHandler = exceptionHandler;
        this.m_swallowException = swallowException;
        return this;
    }

    public String getThreadName() {
        return this.m_threadName;
    }

    public JobInput withThreadName(String threadName) {
        this.m_threadName = threadName;
        return this;
    }

    public Set<String> getExecutionHints() {
        return this.m_executionHints;
    }

    public JobInput withExecutionHint(String hint) {
        this.m_executionHints.add(hint);
        return this;
    }

    public JobInput withExecutionHint(String hint, boolean setExecutionHint) {
        if (setExecutionHint) {
            this.m_executionHints.add(hint);
        }
        return this;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.attr("name", this.m_name);
        builder.ref("executionSemaphore", this.m_executionSemaphore);
        builder.attr("expirationTime", this.m_expirationTime);
        builder.ref("exceptionHandler", this.m_exceptionHandler);
        builder.attr("swallowException", this.m_swallowException);
        builder.attr("threadName", this.m_threadName);
        builder.attr("executionTrigger", (Object)this.m_executionTrigger);
        builder.attr("runContext", (Object)this.m_runContext);
        builder.attr("executionHints", this.m_executionHints);
        return builder.toString();
    }

    public JobInput copy() {
        JobInput copy = BEANS.get(JobInput.class);
        copy.m_name = this.m_name;
        copy.m_executionSemaphore = this.m_executionSemaphore;
        copy.m_expirationTime = this.m_expirationTime;
        copy.m_exceptionHandler = this.m_exceptionHandler;
        copy.m_swallowException = this.m_swallowException;
        copy.m_threadName = this.m_threadName;
        copy.m_runContext = this.m_runContext != null ? this.m_runContext.copy() : null;
        copy.m_executionTrigger = this.m_executionTrigger != null ? this.m_executionTrigger.copy() : null;
        copy.m_executionHints = new HashSet<String>(this.m_executionHints);
        return copy;
    }
}

