/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.inventory.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.scout.rt.platform.config.PlatformConfigProperties;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.inventory.internal.JandexFiles;
import org.eclipse.scout.rt.platform.inventory.internal.LockedFile;
import org.eclipse.scout.rt.platform.util.date.DateUtility;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.JarIndexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JandexInventoryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JandexInventoryBuilder.class);
    public static final String SCOUT_XML_PATH = "META-INF/scout.xml";
    public static final String JANDEX_INDEX_PATH = "META-INF/jandex.idx";
    private final RebuildStrategy m_rebuildStrategy;
    private final List<IndexView> m_indexList;

    public JandexInventoryBuilder() {
        this((Boolean)new PlatformConfigProperties.JandexRebuildProperty().getValue() != false ? RebuildStrategy.ALWAYS : ((Boolean)new PlatformConfigProperties.PlatformDevModeProperty().getValue() != false ? RebuildStrategy.IF_MODIFIED : RebuildStrategy.IF_MISSING));
    }

    public JandexInventoryBuilder(RebuildStrategy rebuildStrategy) {
        this.m_rebuildStrategy = rebuildStrategy;
        this.m_indexList = new ArrayList<IndexView>();
    }

    public RebuildStrategy getRebuildStrategy() {
        return this.m_rebuildStrategy;
    }

    public void scanAllModules() {
        try {
            Collections.list(this.getClass().getClassLoader().getResources(SCOUT_XML_PATH)).parallelStream().map(this::findIndexUri).forEach(this::scanModule);
        }
        catch (IOException ex) {
            throw new PlatformException("Error while reading resources '{}'", SCOUT_XML_PATH, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index scanModule(URI indexUri) {
        try {
            Index index = this.scanModuleUnsafe(indexUri);
            if (index != null) {
                List<IndexView> list = this.m_indexList;
                synchronized (list) {
                    this.m_indexList.add((IndexView)index);
                }
            }
            return index;
        }
        catch (PlatformException p) {
            throw p;
        }
        catch (Exception ex) {
            throw new PlatformException("Cannot scan location '{}' with jandex", indexUri, ex);
        }
    }

    protected Index scanModuleUnsafe(URI indexUri) throws IOException, URISyntaxException {
        if ("file".equals(indexUri.getScheme())) {
            return this.scanFolder(indexUri);
        }
        if ("jar".equals(indexUri.getScheme())) {
            return this.scanJar(indexUri);
        }
        return this.scanOther(indexUri);
    }

    protected Index scanFolder(URI indexUri) throws IOException {
        File indexFile0 = new File(indexUri);
        File classesFolder = indexFile0.getParentFile().getParentFile();
        Throwable throwable = null;
        Object var5_6 = null;
        try (LockedFile indexFile = new LockedFile(indexFile0);){
            IndexMetaData newMeta = null;
            Index index = null;
            boolean canReadFromIndexFile = indexFile.exists();
            if (canReadFromIndexFile) {
                switch (this.m_rebuildStrategy) {
                    case IF_MODIFIED: {
                        newMeta = this.indexMetaData(classesFolder.toPath());
                        long oldModified = indexFile.lastModified();
                        if (newMeta.lastModified() > oldModified) {
                            if (LOG.isInfoEnabled()) {
                                LOG.info("Drop outdated index '{}'. Index timestamp {} is older than folder timestamp {}.", new Object[]{indexUri, DateUtility.format(new Date(oldModified), "yyyy-MM-dd HH:mm:ss.SSS"), DateUtility.format(new Date(newMeta.lastModified()), "yyyy-MM-dd HH:mm:ss.SSS")});
                            }
                            canReadFromIndexFile = false;
                            break;
                        }
                        index = this.readIndex(indexUri, indexFile.newInputStream());
                        int oldFileCount = index.getKnownClasses().size();
                        if (newMeta.fileCount() == oldFileCount) break;
                        LOG.info("Drop divergent index '{}'. Index file count {} != folder file count {}.", new Object[]{indexUri, oldFileCount, newMeta.fileCount()});
                        index = null;
                        canReadFromIndexFile = false;
                        break;
                    }
                    case ALWAYS: {
                        canReadFromIndexFile = false;
                    }
                }
            }
            if (index == null && canReadFromIndexFile) {
                index = this.readIndex(indexUri, indexFile.newInputStream());
            }
            if (index != null) {
                return index;
            }
            if (newMeta == null) {
                newMeta = this.indexMetaData(classesFolder.toPath());
            }
            LOG.info("Rebuild index '{}'. Scanning location...", (Object)indexUri);
            Indexer indexer = new Indexer();
            index = this.createFolderIndex(classesFolder.toPath(), indexer);
            this.writeIndex(index, indexFile);
            if (!indexFile.setLastModified(newMeta.lastModified())) {
                LOG.warn("Cannot set lastModified on '{}'", (Object)indexFile);
            }
            return index;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected Index scanJar(URI indexUri) throws URISyntaxException, IOException {
        String s = indexUri.getRawSchemeSpecificPart();
        Index index = this.readIndex(indexUri);
        if (index != null) {
            return index;
        }
        LOG.info("Found no pre-built '{}'. Scanning location...", (Object)indexUri);
        File jarFile = new File(new URI(s.substring(0, s.lastIndexOf(33))));
        Indexer indexer = new Indexer();
        return JarIndexer.createJarIndex((File)jarFile, (Indexer)indexer, (boolean)false, (boolean)false, (boolean)false).getIndex();
    }

    protected Index scanOther(URI indexUri) {
        Index index = this.readIndex(indexUri);
        if (index != null) {
            return index;
        }
        throw new PlatformException("Unknown protocol in '{}'", indexUri);
    }

    protected IndexMetaData indexMetaData(Path dir) throws IOException {
        AtomicLong lastModifiedRef = new AtomicLong();
        AtomicInteger fileCountRef = new AtomicInteger();
        JandexFiles.walkFileTree(dir, (path, attrs) -> {
            if (!this.acceptPathForIndex(path)) {
                return;
            }
            fileCountRef.incrementAndGet();
            long t = attrs.lastModifiedTime().toMillis();
            if (t > lastModifiedRef.get()) {
                lastModifiedRef.set(t);
            }
        });
        return new IndexMetaData(lastModifiedRef.get(), fileCountRef.get());
    }

    protected boolean acceptPathForIndex(Path path) {
        return true;
    }

    protected URI findIndexUri(URL scoutXmlUrl) {
        String s = scoutXmlUrl.toExternalForm();
        try {
            return new URI(String.valueOf(s.substring(0, s.length() - SCOUT_XML_PATH.length())) + JANDEX_INDEX_PATH);
        }
        catch (URISyntaxException ex) {
            throw new PlatformException("Cannot find index URI from '{}'", s, ex);
        }
    }

    protected Index readIndex(URI indexUri) {
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (BufferedInputStream in = new BufferedInputStream(indexUri.toURL().openStream());){
                return this.readIndex(indexUri, in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (PlatformException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            LOG.debug("No pre-built index found: {}", (Object)indexUri, (Object)e);
            return null;
        }
        catch (Exception ex) {
            throw new PlatformException("Error reading index '{}'", indexUri, ex);
        }
    }

    protected Index readIndex(URI indexUri, InputStream in) {
        try {
            Index index = new IndexReader(in).read();
            LOG.debug("Found pre-built {}", (Object)indexUri);
            return index;
        }
        catch (Exception ex) {
            throw new PlatformException("Error reading index '{}'", indexUri, ex);
        }
    }

    protected Index createFolderIndex(Path dir, Indexer indexer) throws IOException {
        JandexFiles.walkFileTree(dir, (path, attrs) -> this.appendPathToIndex(path, indexer));
        return indexer.complete();
    }

    protected void appendPathToIndex(Path path, Indexer indexer) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            indexer.index(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void writeIndex(Index index, LockedFile f) {
        try {
            LOG.debug("Write jandex index file '{}'", (Object)f);
            new IndexWriter(f.newOutputStream()).write(index);
        }
        catch (Exception ex) {
            LOG.warn("Error while writing jandex index file '{}'", (Object)f, (Object)ex);
        }
    }

    public IndexView finish() {
        return CompositeIndex.create(this.m_indexList);
    }

    protected List<IndexView> getIndexList() {
        return this.m_indexList;
    }

    protected static class IndexMetaData {
        private final long m_lastModified;
        private final int m_fileCount;

        protected IndexMetaData(long lastModified, int fileCount) {
            this.m_lastModified = lastModified;
            this.m_fileCount = fileCount;
        }

        protected long lastModified() {
            return this.m_lastModified;
        }

        protected int fileCount() {
            return this.m_fileCount;
        }
    }

    public static enum RebuildStrategy {
        IF_MISSING,
        IF_MODIFIED,
        ALWAYS;

    }
}

