/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.inventory.internal;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.eclipse.scout.rt.platform.inventory.internal.IJandexFileVisitor;

public final class JandexFiles {
    private static final String CLASS_EXT = ".class";

    private JandexFiles() {
    }

    public static void walkFileTree(Path dir, final IJandexFileVisitor visitor) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                if (attrs.isDirectory() && path.toString().startsWith(".")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (!attrs.isDirectory() && path.toString().endsWith(JandexFiles.CLASS_EXT)) {
                    visitor.visit(path, attrs);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

