/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.inventory.internal;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.platform.inventory.IClassInfo;
import org.eclipse.scout.rt.platform.inventory.IClassInventory;
import org.eclipse.scout.rt.platform.inventory.internal.JandexClassInfo;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class JandexClassInventory
implements IClassInventory {
    private final IndexView m_index;

    public JandexClassInventory(IndexView index) {
        this.m_index = index;
    }

    @Override
    public Set<IClassInfo> getAllKnownSubClasses(Class<?> queryClass) {
        HashSet<ClassInfo> subclasses2;
        Collection subclasses1;
        Assertions.assertNotNull(queryClass);
        if (queryClass.isInterface()) {
            subclasses1 = this.m_index.getAllKnownImplementors(DotName.createSimple((String)queryClass.getName()));
            subclasses2 = new HashSet<ClassInfo>();
            this.collectAllKnownSubinterfacesRecursive(DotName.createSimple((String)queryClass.getName()), subclasses2);
        } else {
            subclasses1 = this.m_index.getAllKnownSubclasses(DotName.createSimple((String)queryClass.getName()));
            subclasses2 = null;
        }
        return this.convertClassInfos(subclasses1, subclasses2);
    }

    @Override
    public Set<IClassInfo> getAllKnownSubClasses(IClassInfo queryClassInfo) {
        HashSet<ClassInfo> subclasses2;
        Collection subclasses1;
        Assertions.assertNotNull(queryClassInfo);
        if (queryClassInfo.isInterface()) {
            subclasses1 = this.m_index.getAllKnownImplementors(DotName.createSimple((String)queryClassInfo.name()));
            subclasses2 = new HashSet<ClassInfo>();
            this.collectAllKnownSubinterfacesRecursive(DotName.createSimple((String)queryClassInfo.name()), subclasses2);
        } else {
            subclasses1 = this.m_index.getAllKnownSubclasses(DotName.createSimple((String)queryClassInfo.name()));
            subclasses2 = null;
        }
        return this.convertClassInfos(subclasses1, subclasses2);
    }

    protected void collectAllKnownSubinterfacesRecursive(DotName queryName, Set<ClassInfo> collector) {
        Collection subinterfaces = this.m_index.getKnownDirectImplementors(queryName);
        if (!subinterfaces.isEmpty()) {
            for (ClassInfo ci : subinterfaces) {
                if (!Modifier.isInterface(ci.flags()) || !collector.add(ci)) continue;
                this.collectAllKnownSubinterfacesRecursive(ci.name(), collector);
            }
        }
    }

    @Override
    public Set<IClassInfo> getKnownAnnotatedTypes(Class<?> annotation) {
        Assertions.assertNotNull(annotation);
        Assertions.assertTrue(annotation.isAnnotation(), "given class is not an annotation: {}", annotation);
        Collection annotationInstances = this.m_index.getAnnotations(DotName.createSimple((String)annotation.getName()));
        return this.convertAnnotationInstance(annotationInstances);
    }

    @Override
    public Set<IClassInfo> getKnownAnnotatedTypes(IClassInfo annotationInfo) {
        Assertions.assertNotNull(annotationInfo);
        Assertions.assertTrue(annotationInfo.isAnnotation(), "given class is not an annotation: {}", annotationInfo.name());
        Collection annotationInstances = this.m_index.getAnnotations(DotName.createSimple((String)annotationInfo.name()));
        return this.convertAnnotationInstance(annotationInstances);
    }

    public IClassInfo getClassInfo(String queryClassName) {
        Assertions.assertNotNull(queryClassName);
        ClassInfo ci = this.m_index.getClassByName(DotName.createSimple((String)queryClassName));
        if (ci == null) {
            return null;
        }
        return new JandexClassInfo(ci);
    }

    public IClassInfo getClassInfo(Class<?> queryClass) {
        Assertions.assertNotNull(queryClass);
        ClassInfo ci = this.m_index.getClassByName(DotName.createSimple((String)queryClass.getName()));
        if (ci == null) {
            return null;
        }
        return new JandexClassInfo(ci);
    }

    protected Set<IClassInfo> convertClassInfos(Collection<ClassInfo> classInfos1, Collection<ClassInfo> optionalClassInfos2) {
        HashSet<IClassInfo> result = new HashSet<IClassInfo>(classInfos1.size() + (optionalClassInfos2 != null ? optionalClassInfos2.size() : 0));
        for (ClassInfo classInfo : classInfos1) {
            result.add(new JandexClassInfo(classInfo));
        }
        if (optionalClassInfos2 != null) {
            for (ClassInfo classInfo : optionalClassInfos2) {
                result.add(new JandexClassInfo(classInfo));
            }
        }
        return result;
    }

    protected Set<IClassInfo> convertAnnotationInstance(Collection<AnnotationInstance> annotationInstances) {
        HashSet<IClassInfo> result = new HashSet<IClassInfo>(annotationInstances.size());
        for (AnnotationInstance annotationInstance : annotationInstances) {
            AnnotationTarget target = annotationInstance.target();
            if (!(target instanceof ClassInfo)) continue;
            result.add(new JandexClassInfo((ClassInfo)target));
        }
        return result;
    }
}

