/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.internal;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.IBeanDecorationFactory;
import org.eclipse.scout.rt.platform.IBeanManager;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.platform.SimpleBeanDecorationFactory;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.config.ConfigUtility;
import org.eclipse.scout.rt.platform.config.IConfigurationValidator;
import org.eclipse.scout.rt.platform.config.PlatformConfigProperties;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.internal.BeanFilter;
import org.eclipse.scout.rt.platform.internal.BeanManagerImplementor;
import org.eclipse.scout.rt.platform.inventory.ClassInventory;
import org.eclipse.scout.rt.platform.inventory.IClassInventory;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformImplementor
implements IPlatform {
    private static final Logger LOG = LoggerFactory.getLogger(PlatformImplementor.class);
    private static final String SCOUT_HEADLESS_PROPERTY = "scout.headless";
    private static final String AWT_HEADLESS_PROPERTY = "java.awt.headless";
    private final ReentrantReadWriteLock m_platformLock = new ReentrantReadWriteLock(true);
    private volatile CountDownLatch m_platformStarted = new CountDownLatch(1);
    private volatile CountDownLatch m_platformStarting = new CountDownLatch(1);
    private final AtomicReference<IPlatform.State> m_state = new AtomicReference<IPlatform.State>(IPlatform.State.PlatformStopped);
    private BeanManagerImplementor m_beanManager;

    @Override
    public IPlatform.State getState() {
        return this.m_state.get();
    }

    @Override
    public IBeanManager getBeanManager() {
        this.m_platformLock.readLock().lock();
        try {
            this.throwOnPlatformInvalid();
            BeanManagerImplementor beanManagerImplementor = this.m_beanManager;
            return beanManagerImplementor;
        }
        finally {
            this.m_platformLock.readLock().unlock();
        }
    }

    @Override
    public void awaitPlatformStarted() {
        PlatformImplementor.awaitLatchSafe(this.m_platformStarted);
        this.throwOnPlatformInvalid();
    }

    @Override
    public void awaitPlatformStarting() {
        PlatformImplementor.awaitLatchSafe(this.m_platformStarting);
    }

    protected void throwOnPlatformInvalid() {
        if (this.getState() == IPlatform.State.PlatformInvalid) {
            throw new PlatformException("The platform is in an invalid state.", new Object[0]);
        }
    }

    protected static void awaitLatchSafe(CountDownLatch latch) {
        boolean interrupted;
        do {
            interrupted = false;
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while (interrupted);
    }

    protected void notifyPlatformStarted() {
        this.m_platformStarted.countDown();
    }

    protected void notifyPlatformStarting() {
        this.m_platformStarting.countDown();
    }

    @Override
    public void start() {
        try {
            this.m_platformLock.writeLock().lock();
            try {
                this.notifyPlatformStarting();
                if (this.m_state.get() != IPlatform.State.PlatformStopped) {
                    throw new PlatformException("Platform is not stopped [m_state=" + (Object)((Object)this.m_state.get()) + "]", new Object[0]);
                }
                try {
                    this.validateHeadless();
                    this.m_beanManager = this.createBeanManager();
                    this.changeState(IPlatform.State.BeanManagerPrepared, true);
                    this.validateConfiguration();
                    this.initBeanDecorationFactory();
                    this.changeState(IPlatform.State.BeanManagerValid, true);
                    this.startCreateImmediatelyBeans();
                }
                catch (Error | RuntimeException e) {
                    LOG.error("Error during platform startup", e);
                    this.changeState(IPlatform.State.PlatformInvalid, true);
                    throw e;
                }
            }
            finally {
                this.m_platformLock.writeLock().unlock();
            }
            this.changeState(IPlatform.State.PlatformStarted, true);
        }
        finally {
            this.notifyPlatformStarted();
        }
    }

    protected void validateHeadless() {
        boolean scoutHeadless = ConfigUtility.getPropertyBoolean(SCOUT_HEADLESS_PROPERTY, true);
        String awtHeadlessStr = System.getProperty(AWT_HEADLESS_PROPERTY);
        boolean awtHeadless = TypeCastUtility.castValue(awtHeadlessStr, Boolean.TYPE);
        String autoSetMsg = "";
        if (scoutHeadless && !awtHeadless) {
            System.setProperty(AWT_HEADLESS_PROPERTY, "true");
            autoSetMsg = " (automatically set by Scout)";
            awtHeadlessStr = "true";
        }
        boolean graphicsEnvironmentHeadless = GraphicsEnvironment.isHeadless();
        LOG.info("Headless mode: {}={}, {}={}{}, GraphicsEnvironment.isHeadless()={}", new Object[]{SCOUT_HEADLESS_PROPERTY, scoutHeadless, AWT_HEADLESS_PROPERTY, awtHeadlessStr, autoSetMsg, graphicsEnvironmentHeadless});
        if (scoutHeadless && !graphicsEnvironmentHeadless) {
            LOG.warn("{} is 'true', but GraphicsEnvironment.isHeadless() reports 'false'. AWT seems to have been already initialized. Please try setting the system property {}=true manually when starting the VM. You can turn off this message by setting {}=false", new Object[]{SCOUT_HEADLESS_PROPERTY, AWT_HEADLESS_PROPERTY, SCOUT_HEADLESS_PROPERTY});
        }
    }

    protected void validateConfiguration() {
        if (!ConfigUtility.isInitialized()) {
            LOG.info("No {} found. Running with empty configuration.", (Object)"config.properties");
            return;
        }
        List<IConfigurationValidator> validators = BEANS.all(IConfigurationValidator.class);
        ArrayList<String> invalidProperties = new ArrayList<String>();
        for (Map.Entry<String, String> config : ConfigUtility.getAllEntries().entrySet()) {
            if (this.isConfigEntryValid(validators, config)) continue;
            invalidProperties.add(config.getKey());
            LOG.error("Config property with key '{}' does not exist or has an invalid value.", (Object)config.getKey());
        }
        if (!invalidProperties.isEmpty()) {
            throw new PlatformException("Cannot start platform due to {} invalid config properties: {}", invalidProperties.size(), invalidProperties);
        }
    }

    protected boolean isConfigEntryValid(List<IConfigurationValidator> validators, Map.Entry<String, String> config) {
        for (IConfigurationValidator validator : validators) {
            if (!validator.isValid(config.getKey(), config.getValue())) continue;
            return true;
        }
        return false;
    }

    protected BeanManagerImplementor newBeanManagerImplementor() {
        return new BeanManagerImplementor();
    }

    protected BeanManagerImplementor createBeanManager() {
        BeanManagerImplementor beanManager = this.newBeanManagerImplementor();
        IClassInventory inv = ClassInventory.get();
        long t0 = System.nanoTime();
        Set<Class> allBeans = new BeanFilter().collect(inv);
        long t1 = System.nanoTime();
        LOG.info("Collected {} beans in {} ms", (Object)allBeans.size(), (Object)StringUtility.formatNanos(t1 - t0));
        for (Class bean : allBeans) {
            beanManager.registerClass(bean);
        }
        long t2 = System.nanoTime();
        LOG.info("Registered {} beans in {} ms", (Object)allBeans.size(), (Object)StringUtility.formatNanos(t2 - t1));
        return beanManager;
    }

    protected void initBeanDecorationFactory() {
        if (this.m_beanManager.getBeanDecorationFactory() != null) {
            return;
        }
        IBean<IBeanDecorationFactory> bean = this.m_beanManager.optBean(IBeanDecorationFactory.class);
        if (bean != null) {
            this.m_beanManager.setBeanDecorationFactory(bean.getInstance());
            return;
        }
        LOG.warn("Using {}. Please verify that this application really has no client or server side {}", (Object)SimpleBeanDecorationFactory.class.getName(), (Object)IBeanDecorationFactory.class.getSimpleName());
        this.m_beanManager.setBeanDecorationFactory(new SimpleBeanDecorationFactory());
    }

    protected void startCreateImmediatelyBeans() {
        this.m_beanManager.startCreateImmediatelyBeans();
    }

    @Override
    public void stop() {
        this.m_beanManager.callPreDestroyOnBeans();
        this.changeState(IPlatform.State.PlatformStopping, true);
        this.m_platformLock.writeLock().lock();
        try {
            this.changeState(IPlatform.State.PlatformStopped, false);
            this.m_platformStarted = new CountDownLatch(1);
            this.m_platformStarting = new CountDownLatch(1);
            this.destroyBeanManager();
        }
        finally {
            this.m_platformLock.writeLock().unlock();
        }
    }

    protected void destroyBeanManager() {
        this.m_beanManager = null;
    }

    protected void changeState(IPlatform.State newState, boolean throwOnIllegalStateChange) {
        if (newState == null) {
            throw new IllegalArgumentException("new state cannot be null.");
        }
        if (this.m_state.get() == newState) {
            return;
        }
        EnumSet<IPlatform.State> possibleExpectedCurrentStates = PlatformImplementor.getPreviousStates(newState);
        if (possibleExpectedCurrentStates == null || possibleExpectedCurrentStates.isEmpty()) {
            throw new IllegalStateException("Unknown state transition: '" + (Object)((Object)newState) + "' has no preceeding state defined.");
        }
        boolean changed = false;
        for (IPlatform.State expectedCurrentState : possibleExpectedCurrentStates) {
            changed = this.m_state.compareAndSet(expectedCurrentState, newState);
            if (changed) break;
        }
        if (!changed && throwOnIllegalStateChange) {
            throw new PlatformException("Invalid state change. Current state (" + (Object)((Object)this.m_state.get()) + ") cannot be changed to " + (Object)((Object)newState) + ". A state change to " + (Object)((Object)newState) + " is only allowed in these states " + possibleExpectedCurrentStates, new Object[0]);
        }
        this.fireStateEvent(newState);
    }

    protected static EnumSet<IPlatform.State> getPreviousStates(IPlatform.State reference) {
        switch (reference) {
            case BeanManagerPrepared: {
                return EnumSet.of(IPlatform.State.PlatformStopped);
            }
            case BeanManagerValid: {
                return EnumSet.of(IPlatform.State.BeanManagerPrepared);
            }
            case PlatformStarted: {
                return EnumSet.of(IPlatform.State.BeanManagerValid);
            }
            case PlatformStopping: {
                return EnumSet.of(IPlatform.State.PlatformStarted);
            }
            case PlatformStopped: {
                return EnumSet.of(IPlatform.State.PlatformStopping);
            }
            case PlatformInvalid: {
                return EnumSet.of(IPlatform.State.BeanManagerPrepared, IPlatform.State.BeanManagerValid, IPlatform.State.PlatformStarted, IPlatform.State.PlatformStopping, IPlatform.State.PlatformStopped);
            }
        }
        return EnumSet.noneOf(IPlatform.State.class);
    }

    protected void fireStateEvent(IPlatform.State newState) {
        if (this.m_beanManager == null) {
            return;
        }
        PlatformEvent event = new PlatformEvent(this, newState);
        try {
            for (IBean<IPlatformListener> bean : this.m_beanManager.getBeans(IPlatformListener.class)) {
                IPlatformListener listener = bean.getInstance();
                long t0 = System.nanoTime();
                listener.stateChanged(event);
                long t1 = System.nanoTime();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("StateEvent {} took {} ms for '{}' ", new Object[]{newState, StringUtility.formatNanos(t1 - t0), bean});
            }
        }
        catch (Error | RuntimeException e) {
            LOG.error("Error during event listener notification.", e);
            this.changeState(IPlatform.State.PlatformInvalid, true);
            throw e;
        }
    }

    @Override
    public boolean inDevelopmentMode() {
        return (Boolean)CONFIG.getPropertyValue(PlatformConfigProperties.PlatformDevModeProperty.class);
    }
}

