/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.IBeanInstanceProducer;
import org.eclipse.scout.rt.platform.exception.BeanCreationException;
import org.eclipse.scout.rt.platform.internal.BeanInstanceUtil;
import org.eclipse.scout.rt.platform.internal.BeanManagerImplementor;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.FinalValue;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBeanInstanceProducer<T>
implements IBeanInstanceProducer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBeanInstanceProducer.class);
    private static final int DEADLOCK_DETECTION_MAX_WAIT_TIME_SECONDS = 90;
    private static final int DEADLOCK_DETECTION_DEBUG_WAIT_TIME_SECONDS = 5;
    private static final ThreadLocal<Deque<String>> INSTANTIATION_STACK = new ThreadLocal();
    private final FinalValue<T> m_applicationScopedInstance = new FinalValue();
    private final AtomicReference<Thread> m_creatorThread = new AtomicReference();

    @Override
    public T produce(IBean<T> bean) {
        this.checkInstanciationInProgress(bean);
        if (BeanManagerImplementor.isApplicationScoped(bean)) {
            return this.getApplicationScopedInstance(bean);
        }
        return this.safeCreateInstance(bean.getBeanClazz());
    }

    private void checkInstanciationInProgress(IBean<T> bean) {
        Deque<String> stack = INSTANTIATION_STACK.get();
        String beanName = bean.getBeanClazz().getName();
        if (stack != null && stack.contains(beanName)) {
            throw new BeanCreationException("The requested bean is currently being created. Creation path: [{}]", stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getApplicationScopedInstance(IBean<T> bean) {
        T instance = this.m_applicationScopedInstance.get();
        if (instance != null) {
            return instance;
        }
        if (this.m_creatorThread.compareAndSet(null, Thread.currentThread())) {
            block24: {
                DefaultBeanInstanceProducer defaultBeanInstanceProducer;
                T t;
                try {
                    instance = this.m_applicationScopedInstance.get();
                    if (instance == null) break block24;
                    t = instance;
                    defaultBeanInstanceProducer = this;
                }
                catch (Throwable throwable) {
                    DefaultBeanInstanceProducer defaultBeanInstanceProducer2 = this;
                    synchronized (defaultBeanInstanceProducer2) {
                        this.m_creatorThread.set(null);
                        this.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (defaultBeanInstanceProducer) {
                    this.m_creatorThread.set(null);
                    this.notifyAll();
                }
                return t;
            }
            instance = this.safeCreateInstance(bean.getBeanClazz());
            this.m_applicationScopedInstance.set(instance);
            T t = instance;
            DefaultBeanInstanceProducer defaultBeanInstanceProducer = this;
            synchronized (defaultBeanInstanceProducer) {
                this.m_creatorThread.set(null);
                this.notifyAll();
            }
            return t;
        }
        Thread creatorThread = this.m_creatorThread.get();
        int maxWaitTimeSeconds = this.getDeadlockDetectionMaxWaitTimeSeconds();
        long maxWaitEndTimeMillis = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(maxWaitTimeSeconds);
        boolean logDebug = LOG.isDebugEnabled();
        do {
            try {
                DefaultBeanInstanceProducer defaultBeanInstanceProducer = this;
                synchronized (defaultBeanInstanceProducer) {
                    long waitTimeMillis;
                    if (this.m_creatorThread.get() == null) {
                        break;
                    }
                    long l = waitTimeMillis = logDebug ? TimeUnit.SECONDS.toMillis(Math.min(maxWaitTimeSeconds, 5)) : maxWaitEndTimeMillis - System.currentTimeMillis();
                    if (waitTimeMillis > 0L) {
                        this.wait(waitTimeMillis);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedError("Thread has been interrupted", new Object[0]);
            }
            if (this.m_creatorThread.get() == null) break;
            if (!logDebug) continue;
            this.logWarnPotentialDeadlock(creatorThread);
            logDebug = false;
        } while (System.currentTimeMillis() < maxWaitEndTimeMillis);
        instance = this.m_applicationScopedInstance.get();
        if (instance != null) {
            return instance;
        }
        if (System.currentTimeMillis() < maxWaitEndTimeMillis) {
            throw new BeanCreationException("Thread was waiting on bean instance creator thread which most likely failed (check the log).", new Object[0]).withContextInfo("beanClass", bean == null || bean.getBeanClazz() == null ? "n/a" : bean.getBeanClazz().getName(), new Object[0]).withContextInfo("creatorThreadID", creatorThread == null ? "n/a" : Long.valueOf(creatorThread.getId()), new Object[0]).withContextInfo("creatorThreadName", creatorThread == null ? "n/a" : creatorThread.getName(), new Object[0]);
        }
        this.logWarnPotentialDeadlock(creatorThread);
        throw new BeanCreationException("Potential deadlock detected: bean is being created by another thread. Either the creation takes longer than {}s or the current and the creator threads are blocking each other (check the log).", maxWaitTimeSeconds).withContextInfo("beanClass", bean == null || bean.getBeanClazz() == null ? "n/a" : bean.getBeanClazz().getName(), new Object[0]).withContextInfo("creatorThreadID", creatorThread == null ? "n/a" : Long.valueOf(creatorThread.getId()), new Object[0]).withContextInfo("creatorThreadName", creatorThread == null ? "n/a" : creatorThread.getName(), new Object[0]);
    }

    private void logWarnPotentialDeadlock(Thread creatorThread) {
        int n;
        if (!LOG.isWarnEnabled()) {
            return;
        }
        Thread current = Thread.currentThread();
        StringBuilder threadInfos = new StringBuilder();
        threadInfos.append("creator Thread: ");
        if (creatorThread == null) {
            threadInfos.append(" n/a");
        } else {
            threadInfos.append(creatorThread.getId()).append(" - ").append(creatorThread.getName());
            StackTraceElement[] stackTraceElementArray = creatorThread.getStackTrace();
            n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement traceElement = stackTraceElementArray[n2];
                threadInfos.append("\n\tat ");
                threadInfos.append(traceElement);
                ++n2;
            }
        }
        threadInfos.append("\ncurrent Thread: ");
        threadInfos.append(current.getId()).append(" - ").append(current.getName());
        int stackElement = -1;
        StackTraceElement[] stackTraceElementArray = current.getStackTrace();
        int n3 = stackTraceElementArray.length;
        n = 0;
        while (n < n3) {
            StackTraceElement traceElement = stackTraceElementArray[n];
            if (++stackElement >= 2) {
                threadInfos.append("\n\tat ");
                threadInfos.append(traceElement);
            }
            ++n;
        }
        LOG.warn("potential deadlock detected\n{}\n", (Object)threadInfos);
    }

    private T safeCreateInstance(Class<? extends T> beanClass) {
        Deque<String> stack = INSTANTIATION_STACK.get();
        boolean removeStack = false;
        if (stack == null) {
            stack = new LinkedList<String>();
            INSTANTIATION_STACK.set(stack);
            removeStack = true;
        }
        try {
            stack.addLast(beanClass.getName());
            T instance = Assertions.assertNotNull(this.createInstance(beanClass));
            this.initializeBean(instance);
            T t = instance;
            return t;
        }
        finally {
            if (removeStack) {
                INSTANTIATION_STACK.remove();
            } else {
                stack.removeLast();
            }
        }
    }

    protected int getDeadlockDetectionMaxWaitTimeSeconds() {
        return 90;
    }

    protected T createInstance(Class<? extends T> beanClass) {
        Constructor<?> injectCons = BeanInstanceUtil.getInjectionConstructor(beanClass);
        if (injectCons != null) {
            try {
                injectCons.setAccessible(true);
                return (T)injectCons.newInstance(BeanInstanceUtil.getInjectionArguments(injectCons.getParameterTypes()));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new BeanCreationException(beanClass.getName(), new Object[]{e});
            }
        }
        return BeanInstanceUtil.createBean(beanClass);
    }

    protected void initializeBean(T beanInstance) {
        BeanInstanceUtil.initializeBeanInstance(beanInstance);
    }
}

