/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.internal;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.Replace;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public class BeanHierarchy<T> {
    private final Class<T> m_clazz;
    private final Set<IBean<T>> m_beans;
    private final ReadWriteLock m_queryCacheLock;
    private List<IBean<T>> m_single;
    private List<IBean<T>> m_all;
    private static final Comparator<IBean<?>> ORDER_COMPARATOR = (o1, o2) -> {
        int cmp = Double.compare(BeanHierarchy.orderOf(o1), BeanHierarchy.orderOf(o2));
        if (cmp != 0) {
            return cmp;
        }
        return o1.getBeanClazz().getName().compareTo(o2.getBeanClazz().getName());
    };

    public BeanHierarchy(Class<T> clazz) {
        this.m_clazz = clazz;
        this.m_beans = new HashSet<IBean<T>>();
        this.m_queryCacheLock = new ReentrantReadWriteLock();
    }

    public Class<T> getClazz() {
        return this.m_clazz;
    }

    public Set<IBean<T>> getBeans() {
        return this.m_beans;
    }

    public IBean<T> getExactBean(Class<?> beanClazz) {
        ArrayList<IBean<T>> beans = CollectionUtility.arrayList(this.m_beans);
        beans.sort(ORDER_COMPARATOR);
        return BeanHierarchy.getExactBean(beans, beanClazz);
    }

    public void addBean(IBean<T> bean) {
        this.invalidate();
        this.m_beans.add(bean);
    }

    public void removeBean(IBean<T> bean) {
        this.invalidate();
        this.m_beans.remove(bean);
    }

    public List<IBean<T>> querySingle() {
        return this.query(true);
    }

    public List<IBean<T>> queryAll() {
        return this.query(false);
    }

    protected void invalidate() {
        this.m_queryCacheLock.writeLock().lock();
        try {
            this.m_single = null;
            this.m_all = null;
        }
        finally {
            this.m_queryCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<IBean<T>> query(boolean querySingle) {
        boolean isInitialized = false;
        this.m_queryCacheLock.readLock().lock();
        try {
            isInitialized = this.m_single != null && this.m_all != null;
        }
        finally {
            this.m_queryCacheLock.readLock().unlock();
        }
        if (!isInitialized) {
            this.m_queryCacheLock.writeLock().lock();
            try {
                void var6_11;
                ArrayList<IBean<T>> list = new ArrayList<IBean<T>>(this.m_beans);
                list.sort(ORDER_COMPARATOR);
                HashSet seenBeans = new HashSet();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    IBean iBean = (IBean)it.next();
                    if (seenBeans.contains(iBean.getBeanClazz())) {
                        it.remove();
                        continue;
                    }
                    seenBeans.add(iBean.getBeanClazz());
                }
                HashMap extendsMap = new HashMap();
                for (IBean iBean : list) {
                    if (!iBean.hasAnnotation(Replace.class)) continue;
                    Assertions.assertFalse(iBean.getBeanClazz().isInterface(), "@{} annotation not supported on interface: {}.", Replace.class.getSimpleName(), iBean);
                    Class superClazz = iBean.getBeanClazz().getSuperclass();
                    Assertions.assertNotNull(superClazz, "@{} annotation not supported for bean '{}' because it has no super class.", Replace.class.getSimpleName(), iBean);
                    Assertions.assertNotEquals(Object.class, superClazz, "@{} annotation not supported for bean '{}' because it has no super class.", Replace.class.getSimpleName(), iBean);
                    Assertions.assertFalse(Modifier.isAbstract(superClazz.getModifiers()), "Cannot replace an abstract super class: {}. Delete this @{} annotation.", iBean, Replace.class.getSimpleName());
                    IBean existingBean = (IBean)extendsMap.get(superClazz);
                    if (existingBean == null) {
                        extendsMap.put(superClazz, iBean);
                        continue;
                    }
                    Assertions.assertFalse(BeanHierarchy.orderOf(existingBean) == BeanHierarchy.orderOf(iBean), "Bean '{}' and '{}' replace the same super class and have identical orders. No unique result possible.", existingBean.getBeanClazz().getName(), iBean.getBeanClazz().getName());
                }
                Class<T> clazz = this.m_clazz;
                while (extendsMap.containsKey(var6_11)) {
                    Class clazz2 = ((IBean)extendsMap.get(var6_11)).getBeanClazz();
                }
                list.removeIf(tiBean -> extendsMap.containsKey(tiBean.getBeanClazz()));
                if (list.isEmpty()) {
                    this.m_all = Collections.emptyList();
                    this.m_single = Collections.emptyList();
                } else {
                    this.m_all = Collections.unmodifiableList(new ArrayList<IBean<T>>(list));
                    IBean<T> exactBean = BeanHierarchy.getExactBean(list, var6_11);
                    if (exactBean != null) {
                        this.m_single = Collections.singletonList(exactBean);
                    } else if (!var6_11.isInterface() && !Modifier.isAbstract(var6_11.getModifiers())) {
                        this.m_single = Collections.emptyList();
                    } else if (list.size() == 1) {
                        this.m_single = Collections.singletonList((IBean)list.get(0));
                    } else {
                        ArrayList<IBean> lowestOrderBeans = new ArrayList<IBean>(list.size());
                        Iterator iterator = list.iterator();
                        IBean curBean = (IBean)iterator.next();
                        double lowestOrder = BeanHierarchy.orderOf(curBean);
                        lowestOrderBeans.add(curBean);
                        while (iterator.hasNext() && BeanHierarchy.orderOf(curBean = (IBean)iterator.next()) == lowestOrder) {
                            lowestOrderBeans.add(curBean);
                        }
                        this.m_single = Collections.unmodifiableList(new ArrayList(lowestOrderBeans));
                    }
                }
            }
            finally {
                this.m_queryCacheLock.writeLock().unlock();
            }
        }
        if (querySingle) {
            return this.m_single;
        }
        return this.m_all;
    }

    protected static <T> IBean<T> getExactBean(List<IBean<T>> list, Class<?> beanClazz) {
        for (IBean<T> bean : list) {
            if (bean.getBeanClazz() != beanClazz) continue;
            return bean;
        }
        return null;
    }

    public static double orderOf(IBean<?> b) {
        Order orderAnnotation = b.getBeanAnnotation(Order.class);
        if (orderAnnotation != null) {
            return orderAnnotation.value();
        }
        return 5000.0;
    }
}

