/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.IgnoreBean;
import org.eclipse.scout.rt.platform.inventory.IClassInfo;
import org.eclipse.scout.rt.platform.inventory.IClassInventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanFilter {
    private static final Logger LOG = LoggerFactory.getLogger(BeanFilter.class);
    private IClassInventory m_classInventory;
    private Set<Class> m_allBeans;

    public Set<Class> collect(IClassInventory classInventory) {
        this.m_classInventory = classInventory;
        this.m_allBeans = new HashSet<Class>();
        HashSet<IClassInfo> annotationsWithBeanAnnotation = new HashSet<IClassInfo>();
        HashSet<IClassInfo> candidates = new HashSet<IClassInfo>();
        for (IClassInfo ci2 : classInventory.getKnownAnnotatedTypes(Bean.class)) {
            if (ci2.isAnnotation()) {
                annotationsWithBeanAnnotation.add(ci2);
                continue;
            }
            candidates.add(ci2);
        }
        for (IClassInfo annotation : annotationsWithBeanAnnotation) {
            try {
                candidates.addAll(classInventory.getKnownAnnotatedTypes(annotation));
            }
            catch (Exception e) {
                LOG.warn("Could not resolve known annotated types for [{}]", (Object)annotation.name(), (Object)e);
            }
        }
        candidates.parallelStream().forEach(ci -> this.collectWithSubClasses((IClassInfo)ci));
        return this.m_allBeans;
    }

    private void collectWithSubClasses(IClassInfo ci) {
        if (ci.isEnum() || ci.isAnnotation() || ci.isSynthetic() || !ci.isPublic()) {
            LOG.debug("Skipping bean candidate '{}' because it is no supported class type (enum, annotation, anonymous class) or is not public.", (Object)ci.name());
            return;
        }
        this.collect(ci);
        if (!ci.isFinal()) {
            try {
                Set<IClassInfo> allKnownSubClasses = this.m_classInventory.getAllKnownSubClasses(ci);
                for (IClassInfo subClass : allKnownSubClasses) {
                    this.collect(subClass);
                }
            }
            catch (Exception e) {
                LOG.warn("Could not resolve known sub classes of [{}]", (Object)ci.name(), (Object)e);
            }
        }
    }

    private void collect(IClassInfo ci) {
        if (ci.hasAnnotation(IgnoreBean.class)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping bean candidate '{}' because it is annotated with '{}'.", (Object)ci.name(), (Object)IgnoreBean.class.getSimpleName());
            }
            return;
        }
        if (!ci.isInstanciable()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping bean candidate '{}' because it is not instanciable.", (Object)ci.name());
            }
            return;
        }
        if (!ci.hasNoArgsConstructor() && !ci.hasInjectableConstructor()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping bean candidate '{}' because it has no empty or injectable constructor().", (Object)ci.name());
            }
            return;
        }
        this.addBean(ci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBean(IClassInfo ci) {
        try {
            Class<?> clazz = ci.resolveClass();
            Set<Class> set = this.m_allBeans;
            synchronized (set) {
                this.m_allBeans.add(clazz);
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not resolve class [{}]", (Object)ci.name(), (Object)ex);
        }
    }
}

