/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.interceptor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.eclipse.scout.rt.platform.interceptor.IInstanceInvocationHandler;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.FinalValue;

public class DecoratingProxy<INSTANCE> {
    private final Class[] m_interfaces;
    private final FinalValue<INSTANCE> m_cachedProxyInstance;
    private final FinalValue<INSTANCE> m_cachedTargetInstance;
    private final IInstanceInvocationHandler<INSTANCE> m_handler;
    private final Callable<INSTANCE> m_targetInstanceProvider;

    public static <T> DecoratingProxy<T> newInstance(IInstanceInvocationHandler<T> handler, Class ... interfaces) {
        return DecoratingProxy.newInstance(handler, () -> null, interfaces);
    }

    public static <T> DecoratingProxy<T> newInstance(IInstanceInvocationHandler<T> handler, Callable<T> targetInstanceProvider, Class ... interfaces) {
        return new DecoratingProxy<T>(handler, targetInstanceProvider, interfaces);
    }

    protected DecoratingProxy(IInstanceInvocationHandler<INSTANCE> handler, Callable<INSTANCE> targetInstanceProvider, Class[] interfaces) {
        this.m_interfaces = (Class[])Assertions.assertNotNull(interfaces).clone();
        this.m_cachedProxyInstance = new FinalValue();
        this.m_cachedTargetInstance = new FinalValue();
        this.m_handler = Assertions.assertNotNull(handler);
        this.m_targetInstanceProvider = Assertions.assertNotNull(targetInstanceProvider);
    }

    protected INSTANCE getTargetInstance() {
        return this.m_cachedTargetInstance.setIfAbsentAndGet(this.m_targetInstanceProvider);
    }

    protected boolean isInstanceEqualTo(Object other, INSTANCE myInstance) {
        if (other == null) {
            return false;
        }
        if (other == this.getProxy()) {
            return true;
        }
        boolean isProxy = Proxy.isProxyClass(other.getClass());
        if (!isProxy) {
            return other.equals(myInstance);
        }
        InvocationHandler handler = Proxy.getInvocationHandler(other);
        if (!(handler instanceof P_InvocationHandler)) {
            return false;
        }
        DecoratingProxy otherProxy = ((P_InvocationHandler)handler).getDecoratingProxy();
        Object otherInstance = otherProxy.getTargetInstance();
        if (otherInstance == null && myInstance == null) {
            return Arrays.equals(this.getInterfaceClasses(), otherProxy.getInterfaceClasses());
        }
        if (otherInstance == myInstance) {
            return true;
        }
        return Objects.equals(myInstance, otherInstance);
    }

    protected Object invokeImpl(Method method, Object[] args) throws Throwable {
        INSTANCE instance = this.getTargetInstance();
        if (Object.class == method.getDeclaringClass()) {
            if ("hashCode".equals(method.getName())) {
                if (instance == null) {
                    return Arrays.hashCode(this.getInterfaceClasses());
                }
                return instance.hashCode();
            }
            if ("equals".equals(method.getName())) {
                return this.isInstanceEqualTo(args[0], instance);
            }
            if ("toString".equals(method.getName())) {
                StringBuilder b = new StringBuilder("{proxy} ");
                if (instance != null) {
                    b.append(instance.toString());
                } else {
                    b.append(Arrays.toString(this.getInterfaceClasses()));
                }
                return b.toString();
            }
        }
        return this.m_handler.invoke(instance, method, args);
    }

    public INSTANCE getProxy() {
        return (INSTANCE)this.m_cachedProxyInstance.setIfAbsentAndGet(() -> Proxy.newProxyInstance(DecoratingProxy.class.getClassLoader(), this.getInterfaceClasses(), new P_InvocationHandler(this)));
    }

    public Class[] getInterfaceClasses() {
        return (Class[])this.m_interfaces.clone();
    }

    protected static final class P_InvocationHandler<T>
    implements InvocationHandler {
        private final DecoratingProxy<T> m_decoratingProxy;

        P_InvocationHandler(DecoratingProxy<T> proxy) {
            this.m_decoratingProxy = proxy;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.getDecoratingProxy().invokeImpl(method, args);
        }

        DecoratingProxy<T> getDecoratingProxy() {
            return this.m_decoratingProxy;
        }
    }
}

