/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.rt.platform.index.AbstractSingleValueIndex;
import org.eclipse.scout.rt.platform.index.IIndex;

public class IndexedStore<ELEMENT>
implements Iterable<ELEMENT> {
    private final List<IIndex<?, ELEMENT>> m_indices = new ArrayList();
    private final ElementIndex<ELEMENT> m_elementIndex = new ElementIndex();

    public IndexedStore() {
        this.m_indices.add(this.m_elementIndex);
    }

    public void add(ELEMENT element) {
        for (IIndex<?, ELEMENT> index : this.m_indices) {
            index.addToIndex(element);
        }
    }

    public void remove(ELEMENT element) {
        for (IIndex<?, ELEMENT> index : this.m_indices) {
            index.removeFromIndex(element);
        }
    }

    public void remove(Collection<ELEMENT> elements) {
        for (ELEMENT element : elements) {
            this.remove(element);
        }
    }

    public List<ELEMENT> values() {
        return this.m_elementIndex.values();
    }

    public boolean contains(ELEMENT element) {
        return this.m_elementIndex.contains(element);
    }

    public int size() {
        return this.values().size();
    }

    public boolean isEmpty() {
        return this.values().isEmpty();
    }

    public void clear() {
        for (IIndex<?, ELEMENT> index : this.m_indices) {
            index.clear();
        }
    }

    public <INDEX extends IIndex<?, ELEMENT>> INDEX registerIndex(INDEX index) {
        this.m_indices.add(index);
        for (ELEMENT element : this.values()) {
            index.addToIndex(element);
        }
        return index;
    }

    public <INDEX extends IIndex<?, ELEMENT>> INDEX unregisterIndex(INDEX index) {
        this.m_indices.remove(index);
        index.clear();
        return index;
    }

    @Override
    public Iterator<ELEMENT> iterator() {
        return this.values().iterator();
    }

    private static class ElementIndex<ELEMENT>
    extends AbstractSingleValueIndex<ELEMENT, ELEMENT> {
        private ElementIndex() {
        }

        @Override
        protected ELEMENT calculateIndexFor(ELEMENT element) {
            return element;
        }
    }
}

