/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.html.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.scout.rt.platform.html.IHtmlContent;
import org.eclipse.scout.rt.platform.html.IHtmlElement;
import org.eclipse.scout.rt.platform.html.internal.HtmlContentBuilder;
import org.eclipse.scout.rt.platform.html.internal.HtmlPlainBuilder;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

public class HtmlNodeBuilder
extends HtmlContentBuilder
implements IHtmlElement {
    private static final long serialVersionUID = 1L;
    private final List<IHtmlContent> m_attributes = new ArrayList<IHtmlContent>();
    private final String m_tag;

    protected String getTag() {
        return this.m_tag;
    }

    public HtmlNodeBuilder(String tag, CharSequence ... texts) {
        this(tag, Arrays.asList(texts));
    }

    public HtmlNodeBuilder(String tag) {
        this(tag, new ArrayList());
    }

    public HtmlNodeBuilder(String tag, List<? extends CharSequence> texts) {
        super(texts);
        this.m_tag = tag;
    }

    @Override
    public void build() {
        this.appendStartTag();
        if (!this.getTexts().isEmpty()) {
            this.appendText();
        }
        this.appendEndTag();
    }

    protected void appendStartTag() {
        this.append("<", false);
        this.append(this.getTag(), true);
        this.appendAttributes();
        this.append(">", false);
    }

    protected void appendEndTag() {
        this.append("</", false);
        this.append(this.getTag(), true);
        this.append(">", false);
    }

    private void appendAttributes() {
        if (!this.m_attributes.isEmpty()) {
            this.append(" ", false);
            this.append(CollectionUtility.format(this.m_attributes, " "), false);
        }
    }

    protected void addAttribute(String name, int value) {
        this.addAttribute(name, Integer.toString(value));
    }

    @Override
    public IHtmlElement addAttribute(String name, CharSequence value) {
        String attribValue = null;
        String doubleQuote = "\"";
        attribValue = value == null ? "" : StringUtility.replace(value.toString(), "\"", "&quot;");
        HtmlContentBuilder content = new HtmlContentBuilder(new HtmlPlainBuilder(this.escape(name)), new HtmlPlainBuilder("=\""), new HtmlPlainBuilder(attribValue), new HtmlPlainBuilder("\""));
        this.m_attributes.add(content);
        return this;
    }

    @Override
    public IHtmlElement addBooleanAttribute(String name) {
        HtmlPlainBuilder content = new HtmlPlainBuilder(this.escape(name));
        this.m_attributes.add(content);
        return this;
    }

    @Override
    public IHtmlElement style(CharSequence value) {
        this.addAttribute("style", value);
        return this;
    }

    @Override
    public IHtmlElement cssClass(CharSequence cssClass) {
        this.addAttribute("class", cssClass);
        return this;
    }

    @Override
    public IHtmlElement appLink(CharSequence ref) {
        return this.appLink(ref, "app-link");
    }

    @Override
    public IHtmlElement appLink(CharSequence ref, CharSequence cssClass) {
        this.cssClass(cssClass);
        this.addAttribute("data-ref", ref);
        return this;
    }
}

