/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.html.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.html.IHtmlContent;
import org.eclipse.scout.rt.platform.html.internal.AbstractExpressionBuilder;

public class HtmlContentBuilder
extends AbstractExpressionBuilder {
    private static final long serialVersionUID = 1L;
    private final List<? extends CharSequence> m_texts;

    public HtmlContentBuilder(CharSequence ... texts) {
        this(Arrays.asList(texts));
    }

    public HtmlContentBuilder(List<? extends CharSequence> texts) {
        for (CharSequence charSequence : texts) {
            if (charSequence == null || charSequence instanceof Serializable) continue;
            throw new ProcessingException("At least one provided char sequence is not serializable: {}", charSequence);
        }
        this.m_texts = new ArrayList<CharSequence>(texts);
    }

    @Override
    public void build() {
        if (!this.m_texts.isEmpty()) {
            this.appendText();
        }
    }

    protected void appendText() {
        for (CharSequence charSequence : this.m_texts) {
            this.append(charSequence, !(charSequence instanceof IHtmlContent));
        }
    }

    protected List<? extends CharSequence> getTexts() {
        return this.m_texts;
    }
}

