/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.html.internal;

import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.html.HtmlHelper;
import org.eclipse.scout.rt.platform.html.IHtmlContent;

public abstract class AbstractExpressionBuilder
implements IHtmlContent {
    private static final long serialVersionUID = 1L;
    private StringBuilder m_buf;
    private boolean m_newLineToBr = true;

    protected StringBuilder validate() {
        if (this.m_buf == null) {
            this.m_buf = new StringBuilder();
            this.build();
        }
        return this.m_buf;
    }

    protected void invalidate() {
        this.m_buf = null;
    }

    @Override
    public boolean isNewLineToBr() {
        return this.m_newLineToBr;
    }

    @Override
    public IHtmlContent withNewLineToBr(boolean newLineToBr) {
        this.m_newLineToBr = newLineToBr;
        return this;
    }

    protected abstract void build();

    @Override
    public int length() {
        return this.validate().length();
    }

    @Override
    public char charAt(int index) {
        return this.validate().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.validate().subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.validate().toString();
    }

    protected void append(CharSequence arg, boolean escape) {
        String toAppend = null;
        toAppend = arg == null ? "" : (escape ? (this.isNewLineToBr() ? this.escapeAndNewLineToBr(arg) : this.escape(arg)) : arg.toString());
        this.m_buf.append(toAppend);
    }

    @Override
    public String toHtml() {
        return this.toString();
    }

    @Override
    public String toPlainText() {
        return BEANS.get(HtmlHelper.class).toPlainText(this.toHtml());
    }

    protected String escape(Object value) {
        return BEANS.get(HtmlHelper.class).escape(value.toString());
    }

    protected String escapeAndNewLineToBr(Object value) {
        return BEANS.get(HtmlHelper.class).escapeAndNewLineToBr(value.toString());
    }
}

