/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.util.StringUtility;

@ApplicationScoped
public class HtmlHelper {
    private static final Pattern HTML_PARAGRAPH_END_TAGS = Pattern.compile("<br/?></div>|</div>|<br/?>|</p>|<p/>|</tr>|</h[1-6]>|</dt>|</dd>|</dl>|</table>|</li>|</head>", 2);
    private static final Pattern HTML_SPACE_END_TAGS = Pattern.compile("</td>|</th>", 2);
    private static final Pattern HTML_TAGS = Pattern.compile("<[^>]+>", 32);
    private static final Pattern MULTIPLE_SPACES = Pattern.compile("[ ]+");
    private static final Pattern SPACES_ADJACENT_LINEBREAKS = Pattern.compile("[ ]+\n[ ]?|[ ]?\n[ ]+");

    public String toPlainText(String html) {
        String s = this.toPlainTextNoTrim(html);
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public String toPlainTextNoTrim(String html) {
        if (html == null || html.isEmpty()) {
            return html;
        }
        String s = StringUtility.getTag(html, "body", true);
        if (s == null) {
            s = html;
        }
        s = StringUtility.replace(s, "\r", "");
        s = StringUtility.replace(s, "\n", " ");
        Matcher matcher = HTML_PARAGRAPH_END_TAGS.matcher(s);
        s = matcher.replaceAll("\n");
        s = StringUtility.replace(s, "<span style=\"white-space:pre\">&#9;</span>", "\t");
        matcher = HTML_SPACE_END_TAGS.matcher(s);
        s = matcher.replaceAll(" ");
        matcher = HTML_TAGS.matcher(s);
        s = matcher.replaceAll("");
        matcher = MULTIPLE_SPACES.matcher(s);
        s = matcher.replaceAll(" ");
        matcher = SPACES_ADJACENT_LINEBREAKS.matcher(s);
        s = matcher.replaceAll("\n");
        s = this.unescape(s);
        s = StringUtility.replace(s, "&nbsp;", " ");
        s = StringUtility.replace(s, "&#160;", " ");
        s = StringUtility.replaceNoCase(s, "&#xa0;", " ");
        s = StringUtility.replace(s, "&#9;", "\t");
        s = StringUtility.replaceNoCase(s, "&#x9;", "\t");
        return s;
    }

    public String escape(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        text = StringUtility.replace(text, "&", "&amp;");
        text = StringUtility.replace(text, "<", "&lt;");
        text = StringUtility.replace(text, ">", "&gt;");
        text = StringUtility.replace(text, "\"", "&quot;");
        text = StringUtility.replace(text, "/", "&#47;");
        text = StringUtility.replace(text, "'", "&#39;");
        return text;
    }

    public String unescape(String html) {
        if (html == null || html.isEmpty()) {
            return html;
        }
        String decoded = StringUtility.replace(html, "&amp;", "&");
        decoded = StringUtility.replace(decoded, "&#38;", "&");
        decoded = StringUtility.replaceNoCase(decoded, "&#x26;", "&");
        decoded = StringUtility.replace(decoded, "&lt;", "<");
        decoded = StringUtility.replace(decoded, "&#60;", "<");
        decoded = StringUtility.replaceNoCase(decoded, "&#x3c;", "<");
        decoded = StringUtility.replace(decoded, "&gt;", ">");
        decoded = StringUtility.replace(decoded, "&#62;", ">");
        decoded = StringUtility.replaceNoCase(decoded, "&#x3e;", ">");
        decoded = StringUtility.replace(decoded, "&quot;", "\"");
        decoded = StringUtility.replace(decoded, "&#34;", "\"");
        decoded = StringUtility.replaceNoCase(decoded, "&#x22;", "\"");
        decoded = StringUtility.replace(decoded, "&#47;", "/");
        decoded = StringUtility.replaceNoCase(decoded, "&#x2f;", "/");
        decoded = StringUtility.replace(decoded, "&apos;", "'");
        decoded = StringUtility.replace(decoded, "&#39;", "'");
        decoded = StringUtility.replaceNoCase(decoded, "&#x27;", "'");
        return decoded;
    }

    public String newLineToBr(String input) {
        String result = StringUtility.replace(input, "\r\n", "<br>");
        return StringUtility.replace(result, "\n", "<br>");
    }

    public String escapeAndNewLineToBr(String text) {
        return this.newLineToBr(this.escape(text));
    }
}

