/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.holders;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.DefaultRuntimeExceptionTranslator;
import org.eclipse.scout.rt.platform.holders.IBeanArrayHolder;

public class BeanArrayHolder<T>
implements IBeanArrayHolder<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<T> m_list;
    private final Map<T, IBeanArrayHolder.State> m_stateList;
    private final Class<T> m_clazz;

    public BeanArrayHolder(Class<T> clazz) {
        this.m_clazz = clazz;
        this.m_list = new ArrayList<T>();
        this.m_stateList = new HashMap<T, IBeanArrayHolder.State>();
    }

    @Override
    public T addBean() {
        T ret = null;
        try {
            ret = this.m_clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw BEANS.get(DefaultRuntimeExceptionTranslator.class).translate(e);
        }
        this.m_list.add(ret);
        this.m_stateList.put(ret, IBeanArrayHolder.State.NON_CHANGED);
        return ret;
    }

    @Override
    public void ensureSize(int size) {
        while (this.m_list.size() < size) {
            this.addBean();
        }
        while (this.m_list.size() > size) {
            this.removeBean(this.m_list.size() - 1);
        }
    }

    public void removeBean(int index) {
        T ret = this.m_list.remove(index);
        this.m_stateList.remove(ret);
    }

    @Override
    public Class<T> getHolderType() {
        return this.m_clazz;
    }

    @Override
    public int getBeanCount(IBeanArrayHolder.State ... states) {
        if (states == null || states.length == 0) {
            return this.m_list.size();
        }
        EnumSet<IBeanArrayHolder.State> state = EnumSet.noneOf(IBeanArrayHolder.State.class);
        Collections.addAll(state, states);
        if (state.isEmpty() || state.contains((Object)IBeanArrayHolder.State.INSERTED) && state.contains((Object)IBeanArrayHolder.State.UPDATED) && state.contains((Object)IBeanArrayHolder.State.DELETED) && state.contains((Object)IBeanArrayHolder.State.NON_CHANGED)) {
            return this.m_list.size();
        }
        int ret = 0;
        for (T b : this.m_list) {
            if (!state.contains((Object)this.m_stateList.get(b))) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public T[] getBeans(IBeanArrayHolder.State ... states) {
        List<Object> ret = new ArrayList();
        EnumSet<IBeanArrayHolder.State> state = EnumSet.noneOf(IBeanArrayHolder.State.class);
        if (states != null) {
            Collections.addAll(state, states);
        }
        if (state.isEmpty() || state.contains((Object)IBeanArrayHolder.State.INSERTED) && state.contains((Object)IBeanArrayHolder.State.UPDATED) && state.contains((Object)IBeanArrayHolder.State.DELETED) && state.contains((Object)IBeanArrayHolder.State.NON_CHANGED)) {
            ret = this.m_list;
        } else {
            for (T b : this.m_list) {
                if (!state.contains((Object)this.m_stateList.get(b))) continue;
                ret.add(b);
            }
        }
        Object[] result = ret.toArray((Object[])Array.newInstance(this.m_clazz, ret.size()));
        return result;
    }

    @Override
    public IBeanArrayHolder.State getRowState(T bean) {
        return this.m_stateList.get(bean);
    }

    @Override
    public void setRowState(T bean, IBeanArrayHolder.State state) {
        this.m_stateList.put(bean, state);
    }
}

