/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.filter;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public class AndFilter<ELEMENT>
implements Predicate<ELEMENT> {
    private final List<Predicate<ELEMENT>> m_filters;

    @SafeVarargs
    public AndFilter(Predicate<ELEMENT> ... filters) {
        this(CollectionUtility.arrayList(filters));
    }

    public AndFilter(Collection<Predicate<ELEMENT>> filters) {
        Assertions.assertTrue(!filters.isEmpty(), "Must have one filter at minimum", new Object[0]);
        this.m_filters = CollectionUtility.arrayList(filters);
    }

    @Override
    public boolean test(ELEMENT element) {
        for (Predicate<ELEMENT> filter : this.m_filters) {
            if (filter.test(element)) continue;
            return false;
        }
        return true;
    }
}

