/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.exception;

import org.eclipse.scout.rt.platform.exception.IProcessingStatus;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.status.Status;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;

public class ProcessingStatus
extends Status
implements IProcessingStatus {
    private static final long serialVersionUID = 1L;
    public static final ProcessingStatus OK_STATUS = new ProcessingStatus(Status.OK_STATUS){
        private static final long serialVersionUID = 1L;

        @Override
        public void setBody(String messageBody) {
            throw new UnsupportedOperationException("The default OK STATUS is unmodifiable.");
        }

        @Override
        public void setException(Throwable exception) {
            throw new UnsupportedOperationException("The default OK STATUS is unmodifiable.");
        }

        @Override
        public void setTitle(String title) {
            throw new UnsupportedOperationException("The default OK STATUS is unmodifiable.");
        }
    };
    private String m_messageTitle;
    private String m_messageBody = "";
    private Throwable m_exception = null;

    public ProcessingStatus(String messageBody) {
        this(messageBody, 0x1000000);
    }

    public ProcessingStatus(String messageBody, int severity) {
        this(null, messageBody, severity);
    }

    public ProcessingStatus(String messageTitle, String messageBody, int severity) {
        this(messageTitle, messageBody, null, 0, severity);
    }

    public ProcessingStatus(String messageBody, Throwable cause, int code, int severity) {
        this(null, messageBody, cause, code, severity);
    }

    public ProcessingStatus(String messageTitle, String messageBody, Throwable cause, int code, int severity) {
        super(null, ProcessingStatus.checkSeverity(severity), code);
        this.m_messageTitle = messageTitle;
        this.m_messageBody = messageBody;
        this.m_exception = cause;
    }

    public ProcessingStatus(IStatus s) {
        super(Assertions.assertNotNull(s).getMessage(), ProcessingStatus.checkSeverity(s.getSeverity()), s.getCode());
        this.m_messageBody = s.getMessage();
        if (s instanceof IProcessingStatus) {
            this.m_messageTitle = ((IProcessingStatus)s).getTitle();
            this.m_exception = ((IProcessingStatus)s).getException();
        }
    }

    @Override
    public boolean isMultiStatus() {
        return false;
    }

    @Override
    public Throwable getException() {
        return this.m_exception;
    }

    @Override
    public String getMessage() {
        return StringUtility.join(": ", this.getTitle(), this.getBody());
    }

    @Override
    public String getBody() {
        return this.m_messageBody;
    }

    @Override
    public String getTitle() {
        return this.m_messageTitle;
    }

    @Override
    public boolean matches(int severityMask) {
        return (this.getSeverity() & severityMask) != 0;
    }

    public void setException(Throwable exception) {
        this.m_exception = exception;
    }

    public void setTitle(String title) {
        this.m_messageTitle = title;
    }

    public void setBody(String messageBody) {
        this.m_messageBody = messageBody;
    }

    private static int checkSeverity(int severity) {
        switch (severity) {
            case 1: 
            case 256: 
            case 65536: 
            case 0x1000000: 
            case 0x10000000: {
                return severity;
            }
        }
        throw new IllegalArgumentException("illegal severity: " + severity);
    }

    @Override
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.attr("title", this.getTitle(), false);
        builder.attr("body", this.getBody(), false);
        builder.attr("severity", this.getSeverityName());
        builder.attr("code", this.getCode());
        builder.attr("exception", (Object)this.m_exception, false);
        return builder.toString();
    }

    @Override
    protected String getSeverityName() {
        switch (this.getSeverity()) {
            case 0x10000000: {
                return "FATAL";
            }
        }
        return super.getSeverityName();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_exception == null ? 0 : this.m_exception.hashCode());
        result = 31 * result + (this.m_messageBody == null ? 0 : this.m_messageBody.hashCode());
        result = 31 * result + (this.m_messageTitle == null ? 0 : this.m_messageTitle.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessingStatus other = (ProcessingStatus)obj;
        if (this.m_exception == null ? other.m_exception != null : !this.m_exception.equals(other.m_exception)) {
            return false;
        }
        if (this.m_messageBody == null ? other.m_messageBody != null : !this.m_messageBody.equals(other.m_messageBody)) {
            return false;
        }
        return !(this.m_messageTitle == null ? other.m_messageTitle != null : !this.m_messageTitle.equals(other.m_messageTitle));
    }
}

