/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.exception;

import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.IExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class DefaultRuntimeExceptionTranslator
implements IExceptionTranslator<RuntimeException> {
    @Override
    public RuntimeException translate(Throwable throwable) {
        Throwable eUnwrapped = BEANS.get(DefaultExceptionTranslator.class).unwrap(throwable);
        RuntimeException eTranslated = this.translateInternal(eUnwrapped);
        RuntimeException eDecorated = BEANS.get(DefaultExceptionTranslator.class).decorate(eTranslated);
        return eDecorated;
    }

    protected RuntimeException translateInternal(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new PlatformException(ObjectUtility.nvl(t.getMessage(), t.getClass().getSimpleName()), new Object[]{t}).withContextInfo("translator", DefaultRuntimeExceptionTranslator.class.getName(), new Object[0]);
    }
}

