/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.exception;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.util.concurrent.ExecutionException;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.exception.IExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.IThrowableWithContextInfo;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.security.SecurityUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class DefaultExceptionTranslator
implements IExceptionTranslator<Exception> {
    @Override
    public Exception translate(Throwable throwable) {
        Throwable eUnwrapped = this.unwrap(throwable);
        Exception eTranslated = this.translateInternal(eUnwrapped);
        Exception eDecorated = this.decorate(eTranslated);
        return eDecorated;
    }

    protected Exception translateInternal(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof Exception) {
            return (Exception)t;
        }
        return new PlatformException(ObjectUtility.nvl(t.getMessage(), t.getClass().getSimpleName()), new Object[]{t}).withContextInfo("translator", DefaultExceptionTranslator.class.getName(), new Object[0]);
    }

    public Throwable unwrap(Throwable throwable) {
        Throwable t = throwable;
        while (t.getCause() != null && this.isWrapperException(t)) {
            t = t.getCause();
        }
        return t;
    }

    public <EXCEPTION extends Throwable> EXCEPTION decorate(EXCEPTION exception) {
        if (exception instanceof IThrowableWithContextInfo) {
            ((IThrowableWithContextInfo)((Object)exception)).withContextInfo("user", SecurityUtility.getPrincipalNames(Subject.getSubject(AccessController.getContext())), new Object[0]);
        }
        return exception;
    }

    protected boolean isWrapperException(Throwable t) {
        return t instanceof UndeclaredThrowableException || t instanceof InvocationTargetException || t instanceof ExecutionException;
    }
}

