/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.events.management;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.ObjectName;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.CreateImmediately;
import org.eclipse.scout.rt.platform.context.PlatformIdentifier;
import org.eclipse.scout.rt.platform.events.ListenerListRegistry;
import org.eclipse.scout.rt.platform.events.ListenerListSnapshot;
import org.eclipse.scout.rt.platform.events.management.IListenerListMonitorMBean;
import org.eclipse.scout.rt.platform.jmx.MBeanUtility;

@ApplicationScoped
@CreateImmediately
public class ListenerListMonitorMBean
implements IListenerListMonitorMBean {
    protected ObjectName jmxObjectName() {
        return MBeanUtility.toJmxName("org.eclipse.scout.rt.platform", PlatformIdentifier.get(), "EventListeners");
    }

    @PostConstruct
    protected void postConstruct() {
        MBeanUtility.register(this.jmxObjectName(), this);
    }

    @PreDestroy
    protected void preDestroy() {
        MBeanUtility.unregister(this.jmxObjectName());
    }

    @Override
    public int getListenerListCount() {
        return ListenerListRegistry.globalInstance().getListenerListCount();
    }

    @Override
    public IListenerListMonitorMBean.ListenerListInfo[] getListenerListInfos() {
        ListenerListSnapshot snapshot = ListenerListRegistry.globalInstance().createSnapshot();
        TreeMap listenerListCount = new TreeMap();
        TreeMap listenerListTypes = new TreeMap();
        snapshot.getData().forEach((listenerList, types) -> {
            String className = listenerList.getClass().getName();
            listenerListCount.put(className, listenerListCount.getOrDefault(className, 0) + 1);
            Map mergedTypes = listenerListTypes.computeIfAbsent(className, className2 -> new TreeMap());
            types.forEach((type, listeners) -> listeners.forEach(listener -> mergedTypes.computeIfAbsent(type, type2 -> new ArrayList()).add(listener.getClass().getName())));
        });
        return (IListenerListMonitorMBean.ListenerListInfo[])listenerListTypes.entrySet().stream().map(e -> this.createListenerListInfo((String)e.getKey(), (Integer)listenerListCount.get(e.getKey()), (Map)e.getValue())).toArray(IListenerListMonitorMBean.ListenerListInfo[]::new);
    }

    protected IListenerListMonitorMBean.ListenerListInfo createListenerListInfo(String listenerListClassName, int listenerListInstanceCount, Map<String, List<String>> listenerTypes) {
        return new IListenerListMonitorMBean.ListenerListInfo(listenerListClassName, listenerListInstanceCount, (IListenerListMonitorMBean.EventType[])listenerTypes.entrySet().stream().map(e -> this.createListenerType((String)e.getKey(), (List)e.getValue())).toArray(IListenerListMonitorMBean.EventType[]::new));
    }

    protected IListenerListMonitorMBean.EventType createListenerType(String listenerType, List<String> listeners) {
        return new IListenerListMonitorMBean.EventType(listenerType, (IListenerListMonitorMBean.ListenerInfo[])listeners.stream().collect(Collectors.groupingBy(name -> name)).entrySet().stream().map(e -> this.createListenerInfo((String)e.getKey(), ((List)e.getValue()).size())).toArray(IListenerListMonitorMBean.ListenerInfo[]::new));
    }

    protected IListenerListMonitorMBean.ListenerInfo createListenerInfo(String listenerClassName, int listenerInstanceCount) {
        return new IListenerListMonitorMBean.ListenerInfo(listenerClassName, listenerInstanceCount);
    }
}

