/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.events.management;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import javax.management.MXBean;
import org.eclipse.scout.rt.platform.util.StringUtility;

@MXBean
public interface IListenerListMonitorMBean {
    public int getListenerListCount();

    public ListenerListInfo[] getListenerListInfos();

    public static class EventType {
        private final String m_eventType;
        private final ListenerInfo[] m_listenerInfos;

        @ConstructorProperties(value={"eventType", "listenerInfos"})
        public EventType(String eventType, ListenerInfo[] listenerInfos) {
            this.m_eventType = eventType;
            this.m_listenerInfos = listenerInfos;
        }

        public String getEventType() {
            return this.m_eventType;
        }

        public ListenerInfo[] getListenerInfos() {
            return this.m_listenerInfos;
        }

        public int getListenerCount() {
            return Arrays.stream(this.m_listenerInfos).mapToInt(l -> l.getListenerCount()).sum();
        }

        public String toString() {
            return String.format("  %s[type=%s, listeners=%s]", EventType.class.getSimpleName(), this.m_eventType, Arrays.toString(this.m_listenerInfos));
        }
    }

    public static class ListenerInfo {
        private final String m_listenerClassName;
        private final int m_listenerCount;

        @ConstructorProperties(value={"listenerClassName", "listenerCount"})
        public ListenerInfo(String listenerClassName, int listenerCount) {
            this.m_listenerClassName = listenerClassName;
            this.m_listenerCount = listenerCount;
        }

        public String getListenerClassName() {
            return this.m_listenerClassName;
        }

        public int getListenerCount() {
            return this.m_listenerCount;
        }

        public String toString() {
            return String.format("%s[className=%s, count=%s]", ListenerInfo.class.getSimpleName(), this.m_listenerClassName, this.m_listenerCount);
        }
    }

    public static class ListenerListInfo {
        private final String m_listenerListClassName;
        private final int m_listenerListInstances;
        private final EventType[] m_listenerTypes;

        @ConstructorProperties(value={"listenerListClassName", "listenerListInstances", "listenerTypes"})
        public ListenerListInfo(String listenerListClassName, int listenerListInstances, EventType[] listenerTypes) {
            this.m_listenerListClassName = listenerListClassName;
            this.m_listenerListInstances = listenerListInstances;
            this.m_listenerTypes = listenerTypes;
        }

        public String getListenerListClassName() {
            return this.m_listenerListClassName;
        }

        public int getListenerListInstances() {
            return this.m_listenerListInstances;
        }

        public EventType[] getListenerTypes() {
            return this.m_listenerTypes;
        }

        public int getListenerCount() {
            return Arrays.stream(this.m_listenerTypes).mapToInt(l -> l.getListenerCount()).sum();
        }

        public String toString() {
            return String.format("%s [className=%s, numInstances=%s, listenerTypes=\n%s\n]", ListenerListInfo.class.getSimpleName(), this.m_listenerListClassName, this.m_listenerListInstances, StringUtility.join("\n", Arrays.asList(this.m_listenerTypes)));
        }
    }
}

