/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.events;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.platform.events.IListenerListWithManagement;

public class ListenerListSnapshot {
    private final Map<IListenerListWithManagement, Map<String, List<Object>>> m_map = new IdentityHashMap<IListenerListWithManagement, Map<String, List<Object>>>();

    public Map<IListenerListWithManagement, Map<String, List<Object>>> getData() {
        return this.m_map;
    }

    protected void add(IListenerListWithManagement listenerList, String context, Object listener) {
        if (listener == null) {
            return;
        }
        if (context == null) {
            context = "*";
        }
        this.m_map.computeIfAbsent(listenerList, listenerList2 -> new TreeMap()).computeIfAbsent(context, context2 -> new ArrayList()).add(listener);
    }

    public void dump() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (PrintWriter out = new PrintWriter(System.out, true);){
            this.dump(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void dump(PrintWriter out) {
        this.m_map.forEach((listenerList, map2) -> {
            out.println("LIST " + listenerList.getClass().getName() + " " + map2.values().stream().mapToInt(list -> list.size()).sum());
            map2.forEach((context, listeners) -> {
                out.println("  TYPE " + context + " " + listeners.size());
                listeners.stream().collect(Collectors.groupingBy(name -> name)).forEach((name, elements) -> out.println("    " + name + ": " + elements.size()));
            });
            out.println();
        });
    }
}

