/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.dataobject;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.dataobject.DoList;
import org.eclipse.scout.rt.platform.dataobject.DoNode;
import org.eclipse.scout.rt.platform.dataobject.IDataObject;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

@Bean
public interface IDoEntity
extends IDataObject {
    public DoNode<?> getNode(String var1);

    public Map<String, DoNode<?>> allNodes();

    default public void putNode(String attributeName, DoNode<?> attribute) {
        Assertions.assertNotNull(attributeName, "attribute name cannot be null", new Object[0]);
        Assertions.assertNotNull(attribute, "attribute node cannot be null for attribute name {}", attributeName);
        attribute.setAttributeName(attributeName);
    }

    public boolean has(String var1);

    public void put(String var1, Object var2);

    public <V> void putList(String var1, List<V> var2);

    public void remove(String var1);

    public void removeIf(Predicate<? super DoNode<?>> var1);

    public Map<String, ?> all();

    default public Optional<DoNode<?>> optNode(String attributeName) {
        return Optional.ofNullable(this.getNode(attributeName));
    }

    default public Object get(String attributeName) {
        DoNode<?> node = this.getNode(attributeName);
        if (node != null) {
            return node.get();
        }
        return null;
    }

    default public <T> T get(String attributeName, Class<T> type) {
        Assertions.assertNotNull(type, "provided type is null", new Object[0]);
        return type.cast(this.get(attributeName));
    }

    default public <T> T get(String attributeName, Function<Object, T> mapper) {
        Assertions.assertNotNull(mapper, "provided mapper function is null", new Object[0]);
        return mapper.apply(this.get(attributeName));
    }

    default public List<Object> getList(String attributeName) {
        return this.getList(attributeName, Object.class);
    }

    default public <T> List<T> getList(String attributeName, Class<T> type) {
        return this.optNode(attributeName).map(n -> Assertions.assertType(n, DoList.class).get()).orElse(null);
    }

    default public <T> List<T> getList(String attributeName, Function<Object, T> mapper) {
        Assertions.assertNotNull(mapper, "provided mapper function is null", new Object[0]);
        return this.getList(attributeName).stream().map(item -> mapper.apply(item)).collect(Collectors.toList());
    }

    default public BigDecimal getDecimal(String attributeName) {
        return TypeCastUtility.castValue(Assertions.assertType(this.get(attributeName), Number.class), BigDecimal.class);
    }

    default public List<BigDecimal> getDecimalList(String attributeName) {
        return this.getList(attributeName, (Object item) -> TypeCastUtility.castValue(Assertions.assertType(item, Number.class), BigDecimal.class));
    }

    default public Boolean getBoolean(String attributeName) {
        return Assertions.assertType(this.get(attributeName), Boolean.class);
    }

    default public List<Boolean> getBooleanList(String attributeName) {
        return this.getList(attributeName, (Object item) -> Assertions.assertType(item, Boolean.class));
    }

    default public String getString(String attributeName) {
        return Assertions.assertType(this.get(attributeName), String.class);
    }

    default public List<String> getStringList(String attributeName) {
        return this.getList(attributeName, (Object item) -> Assertions.assertType(item, String.class));
    }
}

