/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.dataobject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.dataobject.DoNode;
import org.eclipse.scout.rt.platform.dataobject.DoPredicates;
import org.eclipse.scout.rt.platform.dataobject.DoValue;
import org.eclipse.scout.rt.platform.dataobject.IDataObject;

public final class DoList<V>
extends DoNode<List<V>>
implements IDataObject,
Iterable<V> {
    public DoList() {
        this(null, null);
    }

    protected DoList(String attributeName, Consumer<DoNode<List<V>>> lazyCreate) {
        super(attributeName, lazyCreate, new ArrayList());
    }

    public static <V> DoList<V> of(List<V> list) {
        DoList<V> doList = new DoList<V>();
        doList.set(list);
        return doList;
    }

    @Override
    public List<V> get() {
        this.create();
        return (List)super.get();
    }

    @Override
    public void set(List<V> newValue) {
        super.set(newValue != null ? newValue : new ArrayList());
    }

    public V get(int index) {
        return (V)this.get().get(index);
    }

    public void add(V item) {
        this.get().add(item);
    }

    public void addAll(Collection<? extends V> items) {
        if (items != null) {
            this.get().addAll(items);
        }
    }

    public void addAll(V ... items) {
        if (items != null) {
            this.addAll((Collection<? extends V>)Arrays.asList(items));
        }
    }

    public V remove(int index) {
        return (V)this.get().remove(index);
    }

    public boolean remove(V item) {
        return this.get().remove(item);
    }

    public boolean removeAll(Collection<? extends V> items) {
        if (items != null) {
            return this.get().removeAll(items);
        }
        return false;
    }

    public boolean removeAll(V ... items) {
        if (items != null) {
            return this.removeAll((Collection<? extends V>)Arrays.asList(items));
        }
        return false;
    }

    public void updateAll(Collection<? extends V> items) {
        this.clear();
        this.addAll(items);
    }

    public void updateAll(V ... items) {
        this.clear();
        this.addAll(items);
    }

    public void clear() {
        if (this.get().isEmpty()) {
            return;
        }
        this.get().clear();
    }

    public V first() {
        return this.get().size() == 0 ? null : (V)this.get(0);
    }

    public V last() {
        return this.get().size() == 0 ? null : (V)this.get(this.get().size() - 1);
    }

    public int size() {
        return this.get().size();
    }

    public boolean isEmpty() {
        return this.get().isEmpty();
    }

    public Stream<V> stream() {
        return this.get().stream();
    }

    public Stream<V> parallelStream() {
        return this.get().parallelStream();
    }

    @Override
    public Iterator<V> iterator() {
        return this.get().iterator();
    }

    public ListIterator<V> listIterator() {
        return this.get().listIterator();
    }

    public List<V> sort(Comparator<V> comparator) {
        Collections.sort(this.get(), comparator);
        return this.get();
    }

    public <VALUE> V findFirst(Function<V, DoValue<VALUE>> accessor, VALUE value) {
        return this.findFirst(DoPredicates.eq(accessor, value));
    }

    public V findFirst(Predicate<V> predicate) {
        return this.stream().filter(predicate).findFirst().orElse(null);
    }

    public <VALUE> List<V> find(Function<V, DoValue<VALUE>> accessor, VALUE value) {
        return this.find(DoPredicates.eq(accessor, value));
    }

    public List<V> find(Predicate<V> predicate) {
        return this.stream().filter(predicate).collect(Collectors.toList());
    }

    public String toString() {
        return "DoList [m_list=" + this.get() + " exists=" + this.exists() + "]";
    }
}

