/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.dataobject;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.dataobject.IDataObjectMapper;
import org.eclipse.scout.rt.platform.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.holders.IHolder;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

public class DoEntityHolder<T extends IDoEntity>
implements IHolder<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient T m_value;
    private final Class<T> m_clazz;

    public DoEntityHolder() {
        this(null);
    }

    public DoEntityHolder(Class<T> clazz) {
        this.m_clazz = clazz;
    }

    @Override
    public T getValue() {
        return this.m_value;
    }

    @Override
    public void setValue(T value) {
        this.m_value = value;
    }

    @Override
    public Class<T> getHolderType() {
        Class clazz = this.m_clazz;
        if (clazz == null) {
            clazz = TypeCastUtility.getGenericsParameterClass(this.getClass(), DoEntityHolder.class);
        }
        return clazz;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        String text = (String)stream.readObject();
        IDoEntity value = BEANS.get(IDataObjectMapper.class).readValue(text, IDoEntity.class);
        this.setValue((T)value);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        String text = BEANS.get(IDataObjectMapper.class).writeValue(this.getValue());
        stream.writeObject(text);
    }
}

