/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.dataobject;

import java.util.List;
import javax.annotation.PostConstruct;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.dataobject.DoEntity;
import org.eclipse.scout.rt.platform.dataobject.IDataObjectMapper;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@Bean
public class DoEntityBuilder {
    protected DoEntity m_entity;

    @PostConstruct
    protected void init() {
        this.m_entity = BEANS.get(DoEntity.class);
    }

    public DoEntityBuilder put(String attributeName, Object value) {
        this.m_entity.put(attributeName, value);
        return this;
    }

    public <V> DoEntityBuilder putList(String attributeName, List<V> value) {
        this.m_entity.putList(attributeName, value);
        return this;
    }

    public <V> DoEntityBuilder putList(String attributeName, V ... values) {
        this.m_entity.putList(attributeName, CollectionUtility.arrayList(values));
        return this;
    }

    public DoEntity build() {
        return this.m_entity;
    }

    public String buildString() {
        return BEANS.get(IDataObjectMapper.class).writeValue(this.m_entity);
    }
}

