/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.context;

import org.eclipse.scout.rt.platform.chain.callable.ICallableDecorator;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.util.Assertions;

public class RunMonitorCancellableProcessor
implements ICallableDecorator {
    private final RunMonitor m_runMonitor;
    private final RunMonitor m_parentRunMonitor;

    public RunMonitorCancellableProcessor(RunMonitor parentRunMonitor, RunMonitor runMonitor) {
        this.m_runMonitor = Assertions.assertNotNull(runMonitor);
        this.m_parentRunMonitor = parentRunMonitor;
    }

    public RunMonitor getRunMonitor() {
        return this.m_runMonitor;
    }

    public RunMonitor getParentRunMonitor() {
        return this.m_parentRunMonitor;
    }

    @Override
    public ICallableDecorator.IUndecorator decorate() throws Exception {
        if (this.m_parentRunMonitor == null || this.m_runMonitor == this.m_parentRunMonitor) {
            return null;
        }
        this.m_parentRunMonitor.registerCancellable(this.m_runMonitor);
        return new ICallableDecorator.IUndecorator(){

            @Override
            public void undecorate() {
                RunMonitorCancellableProcessor.this.m_runMonitor.addCleanupRunMonitor(RunMonitorCancellableProcessor.this.m_parentRunMonitor);
            }
        };
    }
}

