/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.util.concurrent.ICancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class RunMonitor
implements ICancellable {
    private static final Logger LOG = LoggerFactory.getLogger(RunMonitor.class);
    public static final ThreadLocal<RunMonitor> CURRENT = new ThreadLocal();
    private final ReadWriteLock m_registrationLock = new ReentrantReadWriteLock();
    private final List<ICancellable> m_cancellables = new ArrayList<ICancellable>();
    private volatile boolean m_cancelled;
    private final Object m_cancellationLock = new Object();
    private final List<RunMonitor> m_cleanupRunMonitors = new ArrayList<RunMonitor>(1);

    @Override
    public boolean isCancelled() {
        return this.m_cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean interruptIfRunning) {
        if (this.m_cancelled) {
            return false;
        }
        Object object = this.m_cancellationLock;
        synchronized (object) {
            block6: {
                if (!this.m_cancelled) break block6;
                return false;
            }
            this.m_cancelled = true;
        }
        boolean success = true;
        HashSet<ICancellable> processed = new HashSet<ICancellable>();
        for (ICancellable cancellable : this.getCancellables()) {
            if (!processed.add(cancellable) || this.cancel(cancellable, interruptIfRunning)) continue;
            success = false;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCancellable(ICancellable cancellable) {
        boolean cancel;
        if (this.m_cancelled) {
            this.cancel(cancellable, true);
            return;
        }
        Object object = this.m_cancellationLock;
        synchronized (object) {
            if (this.m_cancelled) {
                cancel = true;
            } else {
                cancel = false;
                this.m_registrationLock.writeLock().lock();
                try {
                    this.m_cancellables.add(cancellable);
                }
                finally {
                    this.m_registrationLock.writeLock().unlock();
                }
            }
        }
        if (cancel) {
            this.cancel(cancellable, true);
        }
    }

    public void unregisterCancellable(ICancellable cancellable) {
        this.m_registrationLock.writeLock().lock();
        try {
            this.m_cancellables.remove(cancellable);
        }
        finally {
            this.m_registrationLock.writeLock().unlock();
        }
        this.checkCleanup();
    }

    protected void addCleanupRunMonitor(RunMonitor cleanupRunMonitor) {
        this.m_registrationLock.writeLock().lock();
        try {
            this.m_cleanupRunMonitors.add(cleanupRunMonitor);
        }
        finally {
            this.m_registrationLock.writeLock().unlock();
        }
        this.checkCleanup();
    }

    protected void checkCleanup() {
        this.m_registrationLock.readLock().lock();
        try {
            if (!this.m_cancellables.isEmpty()) {
                return;
            }
            if (this.m_cleanupRunMonitors.isEmpty()) {
                return;
            }
        }
        finally {
            this.m_registrationLock.readLock().unlock();
        }
        this.m_registrationLock.writeLock().lock();
        try {
            if (!this.m_cancellables.isEmpty()) {
                return;
            }
            if (this.m_cleanupRunMonitors.isEmpty()) {
                return;
            }
            Iterator<RunMonitor> it = this.m_cleanupRunMonitors.iterator();
            while (it.hasNext()) {
                it.next().unregisterCancellable(this);
                it.remove();
            }
        }
        finally {
            this.m_registrationLock.writeLock().unlock();
        }
    }

    protected List<ICancellable> getCancellables() {
        this.m_registrationLock.readLock().lock();
        try {
            ArrayList<ICancellable> arrayList = new ArrayList<ICancellable>(this.m_cancellables);
            return arrayList;
        }
        finally {
            this.m_registrationLock.readLock().unlock();
        }
    }

    protected boolean cancel(ICancellable cancellable, boolean interruptIfRunning) {
        try {
            if (!cancellable.isCancelled()) {
                return cancellable.cancel(interruptIfRunning);
            }
            return false;
        }
        catch (RuntimeException | PlatformError e) {
            LOG.error("Cancellation failed [cancellable={}]", (Object)cancellable, (Object)e);
            return false;
        }
    }
}

