/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.context;

import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.transaction.TransactionScope;
import org.eclipse.scout.rt.platform.util.Assertions;

public final class RunContexts {
    private RunContexts() {
    }

    public static RunContext empty() {
        return BEANS.get(RunContextFactory.class).empty();
    }

    public static RunContext copyCurrent() {
        return RunContexts.copyCurrent(false);
    }

    public static RunContext copyCurrent(boolean orElseEmpty) {
        if (RunContext.CURRENT.get() != null) {
            return BEANS.get(RunContextFactory.class).copyCurrent();
        }
        if (orElseEmpty) {
            return BEANS.get(RunContextFactory.class).empty();
        }
        return (RunContext)Assertions.fail("Not running in a RunContext. Use '{}.empty()' or {}.copyCurrent(true) instead.", RunContexts.class.getSimpleName(), RunContexts.class.getSimpleName());
    }

    @ApplicationScoped
    public static class RunContextFactory {
        public RunContext empty() {
            RunContext rc = this.newInstance().withRunMonitor(BEANS.get(RunMonitor.class)).withTransactionScope(TransactionScope.REQUIRED);
            rc.fillEmpty();
            return rc;
        }

        public RunContext copyCurrent() {
            Assertions.assertNotNull(RunContext.CURRENT.get());
            RunContext newRunContext = this.newInstance();
            newRunContext.fillCurrentValues();
            newRunContext.withRunMonitor(BEANS.get(RunMonitor.class)).withTransactionScope(TransactionScope.REQUIRED).withoutTransactionMembers();
            newRunContext.withParentRunMonitor(RunMonitor.CURRENT.get());
            return newRunContext;
        }

        protected RunContext newInstance() {
            return BEANS.get(RunContext.class);
        }
    }
}

