/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.context;

import java.util.UUID;
import javax.annotation.PostConstruct;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.config.AbstractStringConfigProperty;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.util.StringUtility;

@ApplicationScoped
public class NodeIdentifier {
    private String m_nodeId;

    @PostConstruct
    public void postConstruct() {
        this.m_nodeId = this.compute();
    }

    public String get() {
        return this.m_nodeId;
    }

    protected String compute() {
        String nodeId = (String)CONFIG.getPropertyValue(NodeIdProperty.class);
        if (StringUtility.hasText(nodeId)) {
            return nodeId;
        }
        nodeId = System.getProperty("weblogic.Name");
        if (StringUtility.hasText(nodeId)) {
            return nodeId;
        }
        nodeId = System.getProperty("jboss.node.name");
        if (StringUtility.hasText(nodeId)) {
            return nodeId;
        }
        return UUID.randomUUID().toString();
    }

    public static class NodeIdProperty
    extends AbstractStringConfigProperty {
        @Override
        public String getKey() {
            return "scout.nodeId";
        }

        @Override
        public String description() {
            return "Specifies the cluster node name. If not specified a default id is computed.";
        }
    }
}

