/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.config.IConfigProperty;
import org.eclipse.scout.rt.platform.config.IConfigurationValidator;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPropertyValidator
implements IConfigurationValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigPropertyValidator.class);
    private Map<String, IConfigProperty<?>> m_configProperties;

    protected Map<String, IConfigProperty<?>> getAllConfigProperties() {
        if (this.m_configProperties == null) {
            List<IConfigProperty> configProperties = BEANS.all(IConfigProperty.class);
            HashMap props = new HashMap(configProperties.size());
            for (IConfigProperty prop : configProperties) {
                props.put(prop.getKey(), prop);
            }
            this.m_configProperties = props;
        }
        return this.m_configProperties;
    }

    protected String parseKey(String key) {
        int start = key.indexOf(124) + 1;
        int end = key.indexOf(91, start);
        if (end < start) {
            end = key.length();
        }
        return key.substring(start, end);
    }

    @Override
    public boolean isValid(String key, String value) {
        String parsedKey = this.parseKey(key);
        IConfigProperty<?> property = this.getAllConfigProperties().get(parsedKey);
        if (property == null) {
            return "import".equals(parsedKey);
        }
        try {
            property.getValue();
            this.checkDefaultValueConfiguration(parsedKey, property, value);
        }
        catch (Exception ex) {
            LOG.error("Failed parsing value of config property with key='{}'. Configured value='{}'.", new Object[]{parsedKey, value, ex});
            return false;
        }
        return true;
    }

    protected void checkDefaultValueConfiguration(String parsedKey, IConfigProperty<?> property, String configuredValue) {
        Object defaultValue;
        Object actualValue = property.getValue();
        if (ObjectUtility.equals(actualValue, defaultValue = property.getDefaultValue())) {
            String msg = "Config property with key='{}' has configured value='{}'. This results in an actual value of '{}' which is equal to the default value. Remove config entry for this key to minimize properties file.";
            if (Platform.get().inDevelopmentMode()) {
                LOG.warn(msg, new Object[]{parsedKey, configuredValue, actualValue});
            } else {
                LOG.info(msg, new Object[]{parsedKey, configuredValue, actualValue});
            }
        }
    }
}

