/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.config;

import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.config.AbstractConfigProperty;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.StringUtility;

public abstract class AbstractPositiveIntegerConfigProperty
extends AbstractConfigProperty<Integer, String> {
    private static final Pattern INT_PAT = Pattern.compile("^\\d{1,9}$");

    @Override
    protected Integer parse(String value) {
        if (!StringUtility.hasText(value)) {
            return null;
        }
        if (!INT_PAT.matcher(value).matches()) {
            throw new PlatformException("Invalid integer value '" + value + "' for property '" + this.getKey() + "'.", new Object[0]);
        }
        return Integer.parseInt(value);
    }
}

