/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.config;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.platform.config.ConfigPropertyChangeEvent;
import org.eclipse.scout.rt.platform.config.ConfigUtility;
import org.eclipse.scout.rt.platform.config.IConfigChangedListener;
import org.eclipse.scout.rt.platform.config.IConfigProperty;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;

public abstract class AbstractConfigProperty<DATA_TYPE, RAW_TYPE>
implements IConfigProperty<DATA_TYPE> {
    private final Map<String, P_ParsedPropertyValueEntry<DATA_TYPE>> m_values = new HashMap<String, P_ParsedPropertyValueEntry<DATA_TYPE>>();
    private final FastListenerList<IConfigChangedListener> m_listeners = new FastListenerList();

    @Override
    public DATA_TYPE getDefaultValue() {
        return null;
    }

    protected abstract DATA_TYPE parse(RAW_TYPE var1);

    protected String createKey(String namespace) {
        StringBuilder b = new StringBuilder();
        if (StringUtility.hasText(namespace)) {
            b.append(namespace);
            b.append('|');
        }
        b.append(this.getKey());
        return b.toString();
    }

    @Override
    public synchronized DATA_TYPE getValue(String namespace) {
        String key = this.createKey(namespace);
        P_ParsedPropertyValueEntry entry = this.m_values.computeIfAbsent(key, k -> this.read(namespace));
        if (entry.m_exc != null) {
            throw entry.m_exc;
        }
        return (DATA_TYPE)entry.m_value;
    }

    protected RAW_TYPE readFromSource(String namespace) {
        return (RAW_TYPE)ConfigUtility.getProperty(this.getKey(), null, namespace);
    }

    protected P_ParsedPropertyValueEntry<DATA_TYPE> read(String namespace) {
        Object parsedValue = null;
        PlatformException ex = null;
        try {
            RAW_TYPE value = this.readFromSource(namespace);
            parsedValue = value == null ? this.getDefaultValue() : this.parse(value);
        }
        catch (PlatformException t) {
            ex = t;
        }
        catch (Exception e) {
            ex = new PlatformException(e.getMessage(), new Object[]{e});
        }
        this.fireConfigChangedEvent(new ConfigPropertyChangeEvent(this, null, parsedValue, namespace, 3));
        return new P_ParsedPropertyValueEntry(parsedValue, ex);
    }

    @Override
    public DATA_TYPE getValue() {
        return this.getValue(null);
    }

    @Override
    public synchronized void invalidate() {
        this.m_values.clear();
        this.fireConfigChangedEvent(new ConfigPropertyChangeEvent(this, null, null, null, 2));
    }

    @Override
    public void setValue(DATA_TYPE newValue) {
        this.setValue(newValue, null);
    }

    @Override
    public synchronized void setValue(DATA_TYPE newValue, String namespace) {
        String key = this.createKey(namespace);
        P_ParsedPropertyValueEntry old = this.m_values.put(key, new P_ParsedPropertyValueEntry(newValue, null));
        Object oldValue = null;
        if (old != null) {
            oldValue = old.m_value;
        }
        this.fireConfigChangedEvent(new ConfigPropertyChangeEvent(this, oldValue, newValue, namespace, 1));
    }

    @Override
    public IFastListenerList<IConfigChangedListener> configChangedListeners() {
        return this.m_listeners;
    }

    protected void fireConfigChangedEvent(ConfigPropertyChangeEvent e) {
        this.configChangedListeners().list().forEach(listener -> listener.configPropertyChanged(e));
    }

    private static final class P_ParsedPropertyValueEntry<TYPE> {
        private final TYPE m_value;
        private final PlatformException m_exc;

        private P_ParsedPropertyValueEntry(TYPE value, PlatformException exc) {
            this.m_value = value;
            this.m_exc = exc;
        }
    }
}

