/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.config;

import org.eclipse.scout.rt.platform.config.AbstractConfigProperty;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.StringUtility;

public abstract class AbstractClassConfigProperty<TYPE>
extends AbstractConfigProperty<Class<? extends TYPE>, String> {
    @Override
    protected Class<? extends TYPE> parse(String value) {
        if (!StringUtility.hasText(value)) {
            return null;
        }
        try {
            return Class.forName(value);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new PlatformException("Failed to load class specified by config-property '{}' [config-value={}]", this.getKey(), value, e);
        }
    }
}

