/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.chain.callable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.scout.rt.platform.chain.IChainable;
import org.eclipse.scout.rt.platform.chain.callable.ICallableDecorator;
import org.eclipse.scout.rt.platform.chain.callable.ICallableInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallableChain<RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(CallableChain.class);
    private final LinkedList<IChainable> m_chainables = new LinkedList();

    public CallableChain<RESULT> addFirst(ICallableDecorator decorator) {
        this.m_chainables.addFirst(decorator);
        return this;
    }

    public CallableChain<RESULT> addFirst(ICallableInterceptor<RESULT> interceptor) {
        this.m_chainables.addFirst(interceptor);
        return this;
    }

    public CallableChain<RESULT> addLast(ICallableDecorator decorator) {
        this.m_chainables.addLast(decorator);
        return this;
    }

    public CallableChain<RESULT> addLast(ICallableInterceptor<RESULT> interceptor) {
        this.m_chainables.add(interceptor);
        return this;
    }

    public CallableChain<RESULT> add(ICallableDecorator decorator) {
        this.m_chainables.add(decorator);
        return this;
    }

    public CallableChain<RESULT> add(int index, ICallableDecorator decorator) {
        this.m_chainables.add(index, decorator);
        return this;
    }

    public CallableChain<RESULT> addAll(Collection<? extends IChainable> decorators) {
        this.m_chainables.addAll(decorators);
        return this;
    }

    public CallableChain<RESULT> add(ICallableInterceptor<RESULT> interceptor) {
        this.m_chainables.add(interceptor);
        return this;
    }

    public CallableChain<RESULT> add(int index, ICallableInterceptor<RESULT> interceptor) {
        this.m_chainables.add(index, interceptor);
        return this;
    }

    public CallableChain<RESULT> clear() {
        this.m_chainables.clear();
        return this;
    }

    public List<IChainable> values() {
        return this.m_chainables;
    }

    public RESULT call(Callable<RESULT> command) throws Exception {
        return new Chain<RESULT>(this.m_chainables, command).continueChain();
    }

    public List<IChainable> asList() {
        return new ArrayList<IChainable>(this.m_chainables);
    }

    public static class Chain<RESULT> {
        private final Iterator<IChainable> m_iterator;
        private final Callable<RESULT> m_command;

        public Chain(List<IChainable> chainables, Callable<RESULT> command) {
            this.m_iterator = chainables.iterator();
            this.m_command = command;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RESULT continueChain() throws Exception {
            undecorators = new ArrayList<ICallableDecorator.IUndecorator>();
            try {
                while (this.m_iterator.hasNext()) {
                    next = this.m_iterator.next();
                    if (next instanceof ICallableDecorator) {
                        undecorator = ((ICallableDecorator)next).decorate();
                        if (undecorator == null) continue;
                        undecorators.add(undecorator);
                        continue;
                    }
                    if (!(next instanceof ICallableInterceptor) || !((ICallableInterceptor)next).isEnabled()) continue;
                    interceptor = (ICallableInterceptor)next;
                    var5_4 = interceptor.intercept(this);
                    return var5_4;
                }
                var5_5 = this.m_command.call();
                return var5_5;
            }
            finally {
                i = undecorators.size() - 1;
                ** while (i >= 0)
            }
lbl-1000:
            // 1 sources

            {
                this.undecorateSafe((ICallableDecorator.IUndecorator)undecorators.get(i));
                --i;
                continue;
            }
lbl23:
            // 1 sources

            return var5_4;
        }

        private void undecorateSafe(ICallableDecorator.IUndecorator undecorator) {
            try {
                undecorator.undecorate();
            }
            catch (RuntimeException e) {
                LOG.error("Unexpected error during the undecoration of a command's execution. [undecorator={}, command={}]", new Object[]{undecorator.getClass().getName(), this.m_command, e});
            }
        }
    }
}

