/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.rt.platform.index.AbstractMultiValuesIndex;
import org.eclipse.scout.rt.platform.index.IMultiValueIndex;
import org.eclipse.scout.rt.platform.index.IndexedStore;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

public class TypeParameterBeanRegistry<BEAN> {
    protected final ReadWriteLock m_lock = new ReentrantReadWriteLock();
    protected final Class<BEAN> m_beanType;
    protected final IndexedStore<BeanRegistration<BEAN>> m_inventory = new IndexedStore();
    protected final IMultiValueIndex<Class<?>, BeanRegistration<BEAN>> m_genericTypeIndex;
    protected final Set<Class<?>> m_computedLookupTypes = Collections.synchronizedSet(new HashSet());

    public TypeParameterBeanRegistry(Class<BEAN> beanType) {
        this.m_beanType = beanType;
        this.m_genericTypeIndex = this.m_inventory.registerIndex(new AbstractMultiValuesIndex<Class<?>, BeanRegistration<BEAN>>(){

            @Override
            protected Set<Class<?>> calculateIndexesFor(BeanRegistration<BEAN> beanRegistration) {
                HashSet indexValues = new HashSet();
                indexValues.add(beanRegistration.getGenericTypeParameter());
                indexValues.addAll(beanRegistration.getLazyLookupSubTypes());
                return indexValues;
            }
        });
    }

    public IRegistrationHandle registerBeans(List<BEAN> beans) {
        ArrayList<IRegistrationHandle> registrations = new ArrayList<IRegistrationHandle>();
        for (BEAN bean : beans) {
            registrations.add(this.registerBean(bean));
        }
        return () -> {
            for (IRegistrationHandle registration : registrations) {
                registration.dispose();
            }
        };
    }

    public IRegistrationHandle registerBean(BEAN bean) {
        this.m_computedLookupTypes.clear();
        this.m_lock.writeLock().lock();
        try {
            Class genericParameterType = TypeCastUtility.getGenericsParameterClass(bean.getClass(), this.m_beanType);
            BeanRegistration<BEAN> beanRegistration = new BeanRegistration<BEAN>(bean, genericParameterType);
            this.m_inventory.add(beanRegistration);
            IRegistrationHandle iRegistrationHandle = () -> this.m_inventory.remove(beanRegistration);
            return iRegistrationHandle;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    public List<BEAN> getBeans(Class<?> lookupType) {
        this.updateLookupTypeHierarchyIndex(lookupType);
        this.m_lock.readLock().lock();
        try {
            ArrayList<BEAN> beans = new ArrayList<BEAN>();
            for (BeanRegistration<BEAN> registration : this.m_genericTypeIndex.get(lookupType)) {
                beans.add(registration.getBean());
            }
            ArrayList<BEAN> arrayList = beans;
            return arrayList;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    protected void updateLookupTypeHierarchyIndex(Class<?> lookupType) {
        if (this.m_computedLookupTypes.contains(lookupType)) {
            return;
        }
        this.m_lock.writeLock().lock();
        try {
            if (this.m_computedLookupTypes.contains(lookupType)) {
                return;
            }
            for (BeanRegistration<BEAN> element : this.m_inventory.values()) {
                if (!element.getGenericTypeParameter().isAssignableFrom(lookupType)) continue;
                element.registerLazyLookupSubType(lookupType);
                this.m_inventory.remove(element);
                this.m_inventory.add(element);
            }
            this.m_computedLookupTypes.add(lookupType);
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    protected static class BeanRegistration<T> {
        private final T m_bean;
        private final Class<?> m_genericTypeParameter;
        private final Set<Class<?>> m_lazyLookupSubTypes;

        public BeanRegistration(T bean, Class<?> genericTypeParameter) {
            this.m_bean = bean;
            this.m_genericTypeParameter = genericTypeParameter;
            this.m_lazyLookupSubTypes = new HashSet();
        }

        public void registerLazyLookupSubType(Class<?> lookupType) {
            this.m_lazyLookupSubTypes.add(lookupType);
        }

        public T getBean() {
            return this.m_bean;
        }

        public Class<?> getGenericTypeParameter() {
            return this.m_genericTypeParameter;
        }

        public Set<Class<?>> getLazyLookupSubTypes() {
            return this.m_lazyLookupSubTypes;
        }
    }
}

