/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.platform.AnnotationFactory;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.IBeanInstanceProducer;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.Replace;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public class BeanMetaData {
    private final Class<?> m_beanClazz;
    private final Map<Class<? extends Annotation>, Annotation> m_beanAnnotations;
    private Object m_initialInstance;
    private IBeanInstanceProducer<?> m_producer;

    public BeanMetaData(Class<?> clazz) {
        this(clazz, null);
    }

    public BeanMetaData(Class<?> clazz, Object initialInstance) {
        this.m_beanClazz = Assertions.assertNotNull(clazz);
        this.m_beanAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
        this.readStaticAnnotations(clazz, false);
        this.inheritOrderIfRequired(clazz);
        this.m_initialInstance = initialInstance;
    }

    public BeanMetaData(IBean<?> template) {
        this.m_beanClazz = Assertions.assertNotNull(template.getBeanClazz());
        this.m_beanAnnotations = new HashMap<Class<Annotation>, Annotation>(template.getBeanAnnotations());
        this.m_initialInstance = template.getInitialInstance();
        this.m_producer = template.getBeanInstanceProducer();
    }

    protected void inheritOrderIfRequired(Class<?> startClass) {
        boolean isOrderAnnotationPresent;
        boolean isReplaceAnnotationPresent = this.getBeanAnnotation(Replace.class) != null;
        boolean bl = isOrderAnnotationPresent = this.getBeanAnnotation(Order.class) != null;
        if (isOrderAnnotationPresent || !isReplaceAnnotationPresent) {
            return;
        }
        Class<?> superClass = startClass;
        Order orderAnnot = null;
        while (orderAnnot == null && superClass != null && !Object.class.equals(superClass) && superClass.isAnnotationPresent(Replace.class)) {
            orderAnnot = superClass.getAnnotation(Order.class);
            superClass = superClass.getSuperclass();
        }
        if (orderAnnot == null && superClass != null) {
            orderAnnot = superClass.getAnnotation(Order.class);
        }
        if (orderAnnot != null) {
            this.withAnnotation(orderAnnot);
        }
    }

    protected void readStaticAnnotations(Class<?> clazz, boolean inheritedOnly) {
        if (clazz == null || Object.class.equals(clazz)) {
            return;
        }
        Object[] objectArray = clazz.getAnnotations();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = objectArray[n2];
            if (inheritedOnly) {
                if (a.annotationType().getAnnotation(Inherited.class) != null) {
                    this.m_beanAnnotations.put(a.annotationType(), a);
                }
            } else {
                this.m_beanAnnotations.put(a.annotationType(), a);
            }
            ++n2;
        }
        this.readStaticAnnotations(clazz.getSuperclass(), true);
        objectArray = clazz.getInterfaces();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object ifc = objectArray[n2];
            this.readStaticAnnotations((Class<?>)ifc, true);
            ++n2;
        }
    }

    public Class<?> getBeanClazz() {
        return this.m_beanClazz;
    }

    public Object getInitialInstance() {
        return this.m_initialInstance;
    }

    public BeanMetaData withInitialInstance(Object initialInstance) {
        if (initialInstance != null && !this.m_beanClazz.isInstance(initialInstance)) {
            throw new IllegalArgumentException(String.format("InitialInstance '%s' is not of type '%s'", initialInstance, this.m_beanClazz));
        }
        this.m_initialInstance = initialInstance;
        return this;
    }

    public BeanMetaData withProducer(IBeanInstanceProducer<?> producer) {
        this.m_producer = producer;
        return this;
    }

    public IBeanInstanceProducer<?> getProducer() {
        return this.m_producer;
    }

    public BeanMetaData withReplace(boolean replace) {
        if (replace) {
            this.withAnnotation(AnnotationFactory.createReplace());
        } else {
            this.withoutAnnotation(Replace.class);
        }
        return this;
    }

    public BeanMetaData withOrder(double order) {
        this.withAnnotation(AnnotationFactory.createOrder(order));
        return this;
    }

    public BeanMetaData withApplicationScoped(boolean set) {
        if (set) {
            this.withAnnotation(AnnotationFactory.createApplicationScoped());
        } else {
            this.withoutAnnotation(ApplicationScoped.class);
        }
        return this;
    }

    public <ANNOTATION extends Annotation> ANNOTATION getBeanAnnotation(Class<ANNOTATION> annotationClazz) {
        return (ANNOTATION)this.m_beanAnnotations.get(annotationClazz);
    }

    public Map<Class<? extends Annotation>, Annotation> getBeanAnnotations() {
        return new HashMap<Class<? extends Annotation>, Annotation>(this.m_beanAnnotations);
    }

    public void setBeanAnnotations(Map<Class<? extends Annotation>, Annotation> annotations) {
        this.m_beanAnnotations.clear();
        this.m_beanAnnotations.putAll(annotations);
    }

    public BeanMetaData withAnnotation(Annotation annotation) {
        this.m_beanAnnotations.put(annotation.annotationType(), annotation);
        return this;
    }

    public BeanMetaData withAnnotations(Collection<Annotation> annotations) {
        if (CollectionUtility.hasElements(annotations)) {
            for (Annotation a : annotations) {
                this.withAnnotation(a);
            }
        }
        return this;
    }

    public BeanMetaData withoutAnnotation(Class<? extends Annotation> annotationType) {
        this.m_beanAnnotations.remove(annotationType);
        return this;
    }
}

