/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.IBeanManager;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.util.Assertions;

public final class BEANS {
    private BEANS() {
    }

    public static <T> T get(Class<T> beanClazz) {
        return Assertions.assertNotNull(BEANS.opt(beanClazz), "no instance found for query: {}", beanClazz);
    }

    public static <T> T opt(Class<T> beanClazz) {
        IBean<T> bean = Platform.get().getBeanManager().optBean(beanClazz);
        if (bean != null) {
            return bean.getInstance();
        }
        return null;
    }

    public static <T> Optional<T> optional(Class<T> beanClass) {
        return Optional.ofNullable(BEANS.opt(beanClass));
    }

    public static <T> List<T> all(Class<T> beanClazz) {
        return BEANS.all(beanClazz, null);
    }

    public static <T> List<T> all(Class<T> beanClazz, Predicate<T> filter) {
        List<IBean<T>> beans = Platform.get().getBeanManager().getBeans(beanClazz);
        ArrayList<T> instances = new ArrayList<T>(beans.size());
        for (IBean<T> bean : beans) {
            T instance = bean.getInstance();
            if (instance == null || filter != null && !filter.test(instance)) continue;
            instances.add(instance);
        }
        return instances;
    }

    public static IBeanManager getBeanManager() {
        return Platform.get().getBeanManager();
    }
}

